package com.ximai.system.service;

import java.util.List;
import com.ximai.system.domain.SysUserAssocintionPrint;

/**
 * 人员关联打印机表Service接口
 *
 * @author generator
 * @date 2024-03-16
 */
public interface ISysUserAssocintionPrintService
{
    /**
     * 查询人员关联打印机表
     *
     * @param userPrintId 人员关联打印机表主键
     * @return 人员关联打印机表
     */
    public SysUserAssocintionPrint selectSysUserAssocintionPrintByUserPrintId(Long userPrintId);

    /**
     * 查询人员关联打印机表列表
     *
     * @param sysUserAssocintionPrint 人员关联打印机表
     * @return 人员关联打印机表集合
     */
    public List<SysUserAssocintionPrint> selectSysUserAssocintionPrintList(SysUserAssocintionPrint sysUserAssocintionPrint);

    /**
     * 新增人员关联打印机表
     *
     * @param sysUserAssocintionPrint 人员关联打印机表
     * @return 结果
     */
    public int insertSysUserAssocintionPrint(SysUserAssocintionPrint sysUserAssocintionPrint);

    /**
     * 修改人员关联打印机表
     *
     * @param sysUserAssocintionPrint 人员关联打印机表
     * @return 结果
     */
    public int updateSysUserAssocintionPrint(SysUserAssocintionPrint sysUserAssocintionPrint);

    /**
     * 批量删除人员关联打印机表
     *
     * @param userPrintIds 需要删除的人员关联打印机表主键集合
     * @return 结果
     */
    public int deleteSysUserAssocintionPrintByUserPrintIds(Long[] userPrintIds);

    /**
     * 删除人员关联打印机表信息
     *
     * @param userPrintId 人员关联打印机表主键
     * @return 结果
     */
    public int deleteSysUserAssocintionPrintByUserPrintId(Long userPrintId);

    SysUserAssocintionPrint selectSysUserAssocintionPrintByUserPrintIdUserId(Long userId);
}
