package com.ximai.mes.tm.service;

import com.ximai.mes.tm.domain.TmToolRequestItem;
import com.ximai.mes.tm.domain.TmToolRequestUse;
import com.ximai.mes.tm.domain.TmToolRequestUseItem;

import java.util.List;

/**
 * 刀模版领用单Service接口
 *
 * @author generator
 * @date 2024-02-02
 */
public interface ITmToolRequestUseService {
    /**
     * 查询刀模版领用单
     *
     * @param toolRequestUseId 刀模版领用单主键
     * @return 刀模版领用单
     */
    TmToolRequestUse selectTmToolRequestUseByToolRequestUseId(Long toolRequestUseId);

    /**
     * 查询刀模版领用单列表
     *
     * @param tmToolRequestUse 刀模版领用单
     * @return 刀模版领用单集合
     */
    List<TmToolRequestUse> selectTmToolRequestUseList(TmToolRequestUse tmToolRequestUse);

    int insertTmToolRequestUse(TmToolRequestUse tmToolRequestUse);

    int updateTmToolRequestUse(TmToolRequestUse tmToolRequestUse);

    /**
     * 新增刀模版领用单
     *
     * @param tmToolRequestUse 刀模版领用单
     * @return 结果
     */
    int insertObj(TmToolRequestUse tmToolRequestUse);

    /**
     * 修改刀模版领用单
     *
     * @param tmToolRequestUse 刀模版领用单
     * @return 结果
     */
    int updateObj(TmToolRequestUse tmToolRequestUse);

    /**
     * 批量删除刀模版领用单
     *
     * @param toolRequestUseIds 需要删除的刀模版领用单主键集合
     * @return 结果
     */
    int deleteTmToolRequestUseByToolRequestUseIds(Long[] toolRequestUseIds);

    /**
     * 删除刀模版领用单信息
     *
     * @param toolRequestUseId 刀模版领用单主键
     * @return 结果
     */
    int deleteTmToolRequestUseByToolRequestUseId(Long toolRequestUseId);

    /**
     * 通过申请单id获取领用单勾选工装夹具列表
     *
     * @param toolRequestId 申请单主键
     * @return
     */
    List<TmToolRequestItem> selectTmToolsByToolRequestId(Long toolRequestId);

    /**
     * 通过工序和编排单号获取领用单工装夹具列表
     *
     * @param tmToolRequestUse 申请单主键
     * @return
     */
    List<TmToolRequestUseItem> getToolsByProcessIdAndArrangeCode(TmToolRequestUse tmToolRequestUse);
}
