package com.ximai.mes.report.response;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ximai.common.annotation.Excel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
public class FeedbackResponseExportByList {
    /**
     * 工单类型
     */
    @ApiModelProperty(     "工单类型")
    @Excel(name = "工单类型")
    private String workorderType;

    @ApiModelProperty("客户项目号")
    @Excel(name = "客户项目号")
    private String customerProjectNo;

    @ApiModelProperty("订单单号")
    @Excel(name = "订单单号")
    private String orderCode;

    @ApiModelProperty(     "工单编码")
    @Excel(name = "生产工单")
    private String workorderCode;

    @ApiModelProperty(     "工单名称")
    //@Excel(name = "工单名称")
    private String workorderName;

    /**
     * 产品编号
     */
    @ApiModelProperty(     "产品编号")
    @Excel(name = "产品编号")
    private String productCode;

    /**
     * 产品名称
     */
    @ApiModelProperty(     "产品名称")
    @Excel(name = "产品名称")
    private String productName;


    /**
     * 任务编号
     */
    @ApiModelProperty(     "工序任务号")
    @Excel(name = "工序任务号")
    private String taskCode;



    /**
     * 工序名称
     */
    @ApiModelProperty(     "工序编码")
    @Excel(name = "工序编码")
    private String processCode;
    /**
     * 工序名称
     */
    @ApiModelProperty(     "工序名称")
    @Excel(name = "工序名称")
    private String processName;


    /**
     * 工作中心编号
     */
    @ApiModelProperty(     "工作中心编号")
    @Excel(name = "工作中心编号")
    private String workstationCode;

    /**
     * 工作中心名称
     */
    @ApiModelProperty(     "工作中心名称")
    @Excel(name = "工作中心名称")
    private String workstationName;


    /**
     *
     */
    @ApiModelProperty("工作单元编码")
    @Excel(name = "工作单元编码")
    private String workunitCode;

    @ApiModelProperty("工作单元名称")
    @Excel(name = "工作单元名称")
    private String workunitName;

    @ApiModelProperty("报工人员")
    @Excel(name = "报工人员")
    private String userName;

    @ApiModelProperty("报工人员名称")
    @Excel(name = "报工人员名称")
    private String nickName;

    /**
     * 排产数量
     */
    @ApiModelProperty(     "派工数量")
    @Excel(name = "派工数量")
    private BigDecimal quantity;


    /**
     * 本次报工数量
     */
    @ApiModelProperty(     "报工数量")
    @Excel(name = "报工数量")
    private BigDecimal quantityFeedback;

    /**
     * 合格品数量
     */
    @ApiModelProperty(     "合格数量")
    @Excel(name = "合格数量")
    private BigDecimal quantityQualify;

    /**
     * 不良品数量
     */
    @ApiModelProperty(     "不合格数量")
    @Excel(name = "不合格数量")
    private BigDecimal quantityUnqualify;


    /** 异常原因 */
    @ApiModelProperty(     "异常原因")
    @Excel(name = "不合格原因")
    private String abnormalReason;

    @ApiModelProperty("标准工时")
    @Excel(name = "标准工时")
    private BigDecimal stdWorkingTime;

    @ApiModelProperty("实际工时")
    @Excel(name = "实际工时")
    private BigDecimal machineTime;



//    @ApiModelProperty("实际工时")
//    @Excel(name = "实际工时")
    private BigDecimal machineTimeBigDecimal;
    /**
     * 预计结束时间
     */
    @ApiModelProperty("计划完成时间")
    @Excel(name = "计划完成时间", dateFormat = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date scheduleEndDate;
    /**
     * 报工时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(     "报工时间")
    @Excel(name = "报工时间", dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date feedbackTime;
}
