package com.ximai.mes.pro.service.proWorkOrder;

import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderProcessItem;

import java.util.List;
import java.util.Set;

/**
 * 生产工单工序物料Service接口
 *
 * @author yinjinlu
 * @date 2024-01-23
 */
public interface IProWorkOrderProcessItemService {
    /**
     * 查询生产工单工序物料
     *
     * @param workorderProcessItemId 生产工单工序物料主键
     * @return 生产工单工序物料
     */
    ProWorkOrderProcessItem selectProWorkOrderProcessItemByWorkorderProcessItemId(Long workorderProcessItemId);

    /**
     * 查询生产工单工序物料列表
     *
     * @param proWorkOrderProcessItem 生产工单工序物料
     * @return 生产工单工序物料集合
     */
    List<ProWorkOrderProcessItem> selectProWorkOrderProcessItemList(ProWorkOrderProcessItem proWorkOrderProcessItem);

    /**
     * 新增生产工单工序物料
     *
     * @param proWorkOrderProcessItem 生产工单工序物料
     * @return 结果
     */
    int insertProWorkOrderProcessItem(ProWorkOrderProcessItem proWorkOrderProcessItem);

    /**
     * 修改生产工单工序物料
     *
     * @param proWorkOrderProcessItem 生产工单工序物料
     * @return 结果
     */
    int updateProWorkOrderProcessItem(ProWorkOrderProcessItem proWorkOrderProcessItem);

    /**
     * 批量删除生产工单工序物料
     *
     * @param workorderProcessItemIds 需要删除的生产工单工序物料主键集合
     * @return 结果
     */
    int deleteProWorkOrderProcessItemByWorkorderProcessItemIds(Long[] workorderProcessItemIds);

    /**
     * 删除生产工单工序物料信息
     *
     * @param workorderProcessItemId 生产工单工序物料主键
     * @return 结果
     */
    int deleteProWorkOrderProcessItemByWorkorderProcessItemId(Long workorderProcessItemId);


    void deleteByWorkorderCode(String workorderCode);

    void deleteByWorkorderProcessIds(Set<Long> workorderProcessIds);
}
