package com.ximai.mes.pro.domain.task;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import com.ximai.mes.constant.TaskStatusEnum;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkorder;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

import static com.ximai.mes.constant.WorkorderProcessConst.IS_EXIST_TOOL_NO;

/**
 * 生产任务对象 pro_task
 *
 * @date 2022-05-15
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ProTask extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 任务ID
     */
    @TableId
    private Long taskId;
    /**
     * 任务编号
     */
    @Excel(name = "任务编号")
    private String taskCode;

    /**
     * 任务名称
     */
    @Excel(name = "任务名称")
    private String taskName;

    /**
     * 工作中心ID
     */
    @Excel(name = "工作中心ID")
    private Long workstationId;


    @TableField(exist = false)
    private String workorderCode;


    /**
     * 工作中心编号
     */
    @Excel(name = "工作中心编号")
    private String workstationCode;

    /**
     * 工作中心名称
     */
    @Excel(name = "工作中心名称")
    private String workstationName;

    private Integer ordinal;

    /**
     * 工序ID
     */
    @Excel(name = "工序ID")
    private Long processId;

    /**
     * 工序编码
     */
    @Excel(name = "工序编码")
    private String processCode;


    /**
     * 给前端传一个定位判断字段
     */
    @TableField(exist = false)
    private Long location;


    /**
     * 工序名称
     */
    @Excel(name = "工序名称")
    private String processName;

    private String isCheck;

    /**
     * 产品物料ID
     */
    @Excel(name = "产品物料ID")
    private Long itemId;

    /**
     * 产品物料编码
     */
    @Excel(name = "产品物料编码")
    private String itemCode;

    /**
     * 产品物料名称
     */
    @Excel(name = "产品物料名称")
    private String itemName;

    /**
     * 规格型号
     */
    @Excel(name = "规格型号")
    private String specification;

    /**
     * 单位
     */
    @Excel(name = "单位")
    private String unitOfMeasure;

    /**
     * 排产数量
     */
    @Excel(name = "排产数量")
    private BigDecimal quantity;

    /**
     * 已生产数量
     */
    @Excel(name = "已生产数量")
    private BigDecimal quantityProduced;
    @Excel(name = "良品数量")
    private BigDecimal quantityQualify;
    @Excel(name = "不良品数量")
    private BigDecimal quantityUnqualify;
    /**
     * 待加工数
     */
    @Excel(name = "待生产数量")
    private BigDecimal quantityWait;

    /**
     * 调整数量
     */
    @Excel(name = "调整数量")
    private BigDecimal quantityChanged;

    /**
     * 客户ID
     */
    @Excel(name = "客户ID")
    private Long clientId;

    /**
     * 客户编码
     */
    @Excel(name = "客户编码")
    private String clientCode;

    /**
     * 客户名称
     */
    @Excel(name = "客户名称")
    private String clientName;

    /**
     * 客户简称
     */
    @Excel(name = "客户简称")
    private String clientNick;

    /**
     * 开始生产时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "开始生产时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;

    /**
     * 完成生产时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "完成生产时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;

    /**
     * 预计开始时间
     */
    @ApiModelProperty("计划开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date scheduleStartDate;

    /**
     * 预计结束时间
     */
    @ApiModelProperty("计划结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date scheduleEndDate;


    /**
     * 生产时长
     */
    @Excel(name = "生产时长")
    private Long duration;

    /**
     * 甘特图显示颜色
     */
    @Excel(name = "甘特图显示颜色")
    private String colorCode;

    /**
     * 需求日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "需求日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date requestDate;

    private String status;

    /**
     * 预留字段1
     */
    private String attr1;

    /**
     * 预留字段2
     */
    private String attr2;

    /**
     * 预留字段3
     */
    private Long attr3;

    /**
     * 预留字段4
     */
    private Long attr4;

    /**
     * 编排单号
     */
    private String arrangeCode;

    /**
     * 任务批次号
     */
    private String taskBatch;
    @TableField(exist = false)
    private String taskBatchStr;

    @ApiModelProperty("是否最后工序")
    private Integer isLastProcess;

    @TableField(exist = false)
    private Long workunitId;

    @TableField(exist = false)
    private Double arrangeFeedbackSum;

    @TableField(exist = false)
    private String workunitName;

    @TableField(exist = false)
    private String workunitCode;

    @TableField(exist = false)
    private Long taskWorkunitId;


    @TableField(exist = false)
    private Long workorderId;


    @TableField(exist = false)
    private String statusStr;

    @ApiModelProperty("是否包装工序")
    @TableField(exist = false)
    private String isPackage;

    @ApiModelProperty("是否序列号报工")
    @TableField(exist = false)
    private String isSerialReport;

    @TableField(exist = false)
    private String statusName;
    @TableField(exist = false)
    private List<String> statusList = new ArrayList<>();
    @TableField(exist = false)
    private List<ProWorkorder> proWorkorderList;
    @TableField(exist = false)
    private String[] statusArr;

    @TableField(exist = false)
    private Integer purseType;

    private Integer taskType;

    private Integer closeType;

    private String isExistTool = IS_EXIST_TOOL_NO;

    private String idx;
    @ApiModelProperty("超报标识")
    private Boolean surpassState;
    @TableField(exist = false)
    private String processRemark;
    public String getStatusName() {
        return TaskStatusEnum.getStatusCn(this.getStatus());
    }

    public List<String> getStatusList() {
        if (this.statusStr != null && !"".equals(this.statusStr)) {
            Collections.addAll(statusList, statusStr.split(","));
        }
        return statusList;
    }
}
