package com.ximai.mes.od.service.impl;

import com.ximai.common.utils.data.DateUtils;
import com.ximai.mes.od.domain.OdPurchaseOrderDetail;
import com.ximai.mes.od.mapper.OdPurchaseOrderDetailMapper;
import com.ximai.mes.od.service.IOdPurchaseOrderDetailService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 客户采购订单Service业务层处理
 *
 * @author yinjinlu
 * @date 2024-01-23
 */
@Service
public class OdPurchaseOrderDetailServiceImpl implements IOdPurchaseOrderDetailService {
    @Autowired
    private OdPurchaseOrderDetailMapper odPurchaseOrderDetailMapper;

    /**
     * 查询客户采购订单
     *
     * @param id 客户采购订单主键
     * @return 客户采购订单
     */
    @Override
    public OdPurchaseOrderDetail selectOdPurchaseOrderDetailById(String id) {
        return odPurchaseOrderDetailMapper.selectOdPurchaseOrderDetailById(id);
    }

    /**
     * 查询客户采购订单列表
     *
     * @param odPurchaseOrderDetail 客户采购订单
     * @return 客户采购订单
     */
    @Override
    public List<OdPurchaseOrderDetail> selectOdPurchaseOrderDetailList(OdPurchaseOrderDetail odPurchaseOrderDetail) {
        return odPurchaseOrderDetailMapper.selectOdPurchaseOrderDetailList(odPurchaseOrderDetail);
    }

    /**
     * 新增客户采购订单
     *
     * @param odPurchaseOrderDetail 客户采购订单
     * @return 结果
     */
    @Override
    public int insertOdPurchaseOrderDetail(OdPurchaseOrderDetail odPurchaseOrderDetail) {
        odPurchaseOrderDetail.setCreateTime(DateUtils.getNowDate());
        return odPurchaseOrderDetailMapper.insertOdPurchaseOrderDetail(odPurchaseOrderDetail);
    }

    /**
     * 修改客户采购订单
     *
     * @param odPurchaseOrderDetail 客户采购订单
     * @return 结果
     */
    @Override
    public int updateOdPurchaseOrderDetail(OdPurchaseOrderDetail odPurchaseOrderDetail) {
        odPurchaseOrderDetail.setUpdateTime(DateUtils.getNowDate());
        return odPurchaseOrderDetailMapper.updateOdPurchaseOrderDetail(odPurchaseOrderDetail);
    }

    /**
     * 批量删除客户采购订单
     *
     * @param ids 需要删除的客户采购订单主键
     * @return 结果
     */
    @Override
    public int deleteOdPurchaseOrderDetailByIds(String[] ids) {
        return odPurchaseOrderDetailMapper.deleteOdPurchaseOrderDetailByIds(ids);
    }

    /**
     * 删除客户采购订单信息
     *
     * @param id 客户采购订单主键
     * @return 结果
     */
    @Override
    public int deleteOdPurchaseOrderDetailById(String id) {
        return odPurchaseOrderDetailMapper.deleteOdPurchaseOrderDetailById(id);
    }
}
