package com.ximai.mes.md.service.impl;

import java.util.List;
import com.ximai.common.utils.data.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.md.mapper.MdClientContactMapper;
import com.ximai.mes.md.domain.MdClientContact;
import com.ximai.mes.md.service.IMdClientContactService;

/**
 * 客户系人Service业务层处理
 *
 * @author yinjinlu
 * @date 2024-01-19
 */
@Service
public class MdClientContactServiceImpl implements IMdClientContactService
{
    @Autowired
    private MdClientContactMapper mdClientContactMapper;

    /**
     * 查询客户系人
     *
     * @param id 客户系人主键
     * @return 客户系人
     */
    @Override
    public MdClientContact selectMdClientContactById(String id)
    {
        return mdClientContactMapper.selectMdClientContactById(id);
    }

    /**
     * 查询客户系人列表
     *
     * @param mdClientContact 客户系人
     * @return 客户系人
     */
    @Override
    public List<MdClientContact> selectMdClientContactList(MdClientContact mdClientContact)
    {
        return mdClientContactMapper.selectMdClientContactList(mdClientContact);
    }

    /**
     * 新增客户系人
     *
     * @param mdClientContact 客户系人
     * @return 结果
     */
    @Override
    public int insertMdClientContact(MdClientContact mdClientContact)
    {
        mdClientContact.setCreateTime(DateUtils.getNowDate());
        return mdClientContactMapper.insertMdClientContact(mdClientContact);
    }

    /**
     * 修改客户系人
     *
     * @param mdClientContact 客户系人
     * @return 结果
     */
    @Override
    public int updateMdClientContact(MdClientContact mdClientContact)
    {
        mdClientContact.setUpdateTime(DateUtils.getNowDate());
        return mdClientContactMapper.updateMdClientContact(mdClientContact);
    }

    /**
     * 批量删除客户系人
     *
     * @param ids 需要删除的客户系人主键
     * @return 结果
     */
    @Override
    public int deleteMdClientContactByIds(String[] ids)
    {
        return mdClientContactMapper.deleteMdClientContactByIds(ids);
    }

    /**
     * 删除客户系人信息
     *
     * @param id 客户系人主键
     * @return 结果
     */
    @Override
    public int deleteMdClientContactById(String id)
    {
        return mdClientContactMapper.deleteMdClientContactById(id);
    }
}
