
package com.ximai.mes.kanban.controller;

import com.ximai.common.core.domain.AjaxResult;
import com.ximai.mes.kanban.dto.abnormal.AbnormalMonthStatDto;
import com.ximai.mes.kanban.dto.equipment.EquipmentQuery;
import com.ximai.mes.kanban.dto.equipment.EquipmentStatDto;
import com.ximai.mes.kanban.service.KanbanAbnormalService;
import com.ximai.mes.kanban.service.KanbanEquipmentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api("看板设备数据接口")
@RestController
@RequestMapping("/kanban/equipment")
public class KanbanEquipmentController {

    @Autowired
    KanbanEquipmentService kanbanEquipmentService;

    @ApiOperation("设备分布数据")
    @PostMapping("/currentMonthStat")
    public AjaxResult<EquipmentStatDto> currentMonthStat(@RequestBody EquipmentQuery equipmentQuery) {
        EquipmentStatDto rst = kanbanEquipmentService.currentMonthStat(equipmentQuery);
        return AjaxResult.success(rst);
    }


}
