package com.ximai.mes.pro.service.impl;

import com.ximai.common.utils.SecurityUtils;
import com.ximai.common.utils.data.DateUtils;
import com.ximai.mes.pro.domain.ProPauseWork;
import com.ximai.mes.pro.domain.task.ProTask;
import com.ximai.mes.pro.mapper.ProPauseWorkMapper;
import com.ximai.mes.pro.service.IProPauseWorkService;
import com.ximai.mes.qc.domain.QcAbnormalReport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;


/**
 * 暂停作业记录表Service业务层处理
 *
 * @author generator
 * @date 2024-03-12
 */
@Service
public class ProPauseWorkServiceImpl implements IProPauseWorkService {
    @Autowired
    private ProPauseWorkMapper proPauseWorkMapper;


    /**
     * 查询暂停作业记录表
     *
     * @param pauseWorkId 暂停作业记录表主键
     * @return 暂停作业记录表
     */
    @Override
    public ProPauseWork selectProPauseWorkByPauseWorkId(Long pauseWorkId) {
        return proPauseWorkMapper.selectProPauseWorkByPauseWorkId(pauseWorkId);
    }

    /**
     * 查询暂停作业记录表列表
     *
     * @param proPauseWork 暂停作业记录表
     * @return 暂停作业记录表
     */
    @Override
    public List<ProPauseWork> selectProPauseWorkList(ProPauseWork proPauseWork) {
        return proPauseWorkMapper.selectProPauseWorkList(proPauseWork);
    }

    /**
     * 新增暂停作业记录表
     *
     * @param proPauseWork 暂停作业记录表
     * @return 结果
     */
    @Override
    public int insertProPauseWork(ProPauseWork proPauseWork) {
        proPauseWork.setCreateBy(SecurityUtils.getUsername());
        proPauseWork.setCreateTime(DateUtils.getNowDate());
        return proPauseWorkMapper.insertProPauseWork(proPauseWork);
    }

    /**
     * 修改暂停作业记录表
     *
     * @param proPauseWork 暂停作业记录表
     * @return 结果
     */
    @Override
    public int updateProPauseWork(ProPauseWork proPauseWork) {
        proPauseWork.setUpdateBy(SecurityUtils.getUsername());
        proPauseWork.setUpdateTime(DateUtils.getNowDate());
        return proPauseWorkMapper.updateProPauseWork(proPauseWork);
    }

    /**
     * 批量删除暂停作业记录表
     *
     * @param pauseWorkIds 需要删除的暂停作业记录表主键
     * @return 结果
     */
    @Override
    public int deleteProPauseWorkByPauseWorkIds(Long[] pauseWorkIds) {
        return proPauseWorkMapper.deleteProPauseWorkByPauseWorkIds(pauseWorkIds);
    }

    /**
     * 删除暂停作业记录表信息
     *
     * @param pauseWorkId 暂停作业记录表主键
     * @return 结果
     */
    @Override
    public int deleteProPauseWorkByPauseWorkId(Long pauseWorkId) {
        return proPauseWorkMapper.deleteProPauseWorkByPauseWorkId(pauseWorkId);
    }


    @Override
    public void insertObj(ProTask proTask) {
        ProPauseWork proPauseWork = new ProPauseWork();
        proPauseWork.setTaskId(proTask.getTaskId());
        List<ProPauseWork> proPauseWorks = this.selectProPauseWorkList(proPauseWork);

        if (proPauseWorks.size() == 0) {
            ProPauseWork pro = new ProPauseWork();
            pro.setTaskId(proTask.getTaskId());
            pro.setTaskWorkunitId(proTask.getTaskWorkunitId());
            pro.setWorkunitId(proTask.getWorkunitId());
            pro.setAbnormalReason(proTask.getAttr1());
            pro.setAbnormalDescribe(proTask.getAttr2());
            pro.setPauseNum(1L);
            pro.setPauseType(0L);
            pro.setUpdateBy(SecurityUtils.getUsername());
            pro.setUpdateTime(DateUtils.getNowDate());
            proPauseWorkMapper.insertProPauseWork(pro);
        } else {
            List<Long> longs = new ArrayList<>();
            int i = 0;
            for (ProPauseWork pro : proPauseWorks) {
                if (Objects.isNull(pro.getPauseType())) {
                    continue;
                }
                if (pro.getPauseType() == 0) {
                    i++;
                    longs.add(pro.getPauseNum());
                }
            }
            if (i == 0) {
                ProPauseWork pro = new ProPauseWork();
                pro.setTaskId(proTask.getTaskId());
                pro.setTaskWorkunitId(proTask.getTaskWorkunitId());
                pro.setWorkunitId(proTask.getWorkunitId());
                pro.setAbnormalReason(proTask.getAttr1());
                pro.setAbnormalDescribe(proTask.getAttr2());
                pro.setPauseNum(1L);
                pro.setPauseType(0L);
                pro.setUpdateBy(SecurityUtils.getUsername());
                pro.setUpdateTime(DateUtils.getNowDate());
                proPauseWorkMapper.insertProPauseWork(pro);
            } else {
                Long max1 = Collections.max(longs);
                ProPauseWork pro = new ProPauseWork();
                pro.setTaskId(proTask.getTaskId());
                pro.setTaskWorkunitId(proTask.getTaskWorkunitId());
                pro.setWorkunitId(proTask.getWorkunitId());
                pro.setAbnormalReason(proTask.getAttr1());
                pro.setAbnormalDescribe(proTask.getAttr2());
                pro.setPauseNum(max1 + 1);
                pro.setPauseType(0L);
                pro.setUpdateBy(SecurityUtils.getUsername());
                pro.setUpdateTime(DateUtils.getNowDate());
                proPauseWorkMapper.insertProPauseWork(pro);
            }
        }

    }

    @Override
    public void insertProPauseWorks(ProTask proTask) {
        ProPauseWork proPauseWork = new ProPauseWork();
        proPauseWork.setTaskId(proTask.getTaskId());
        List<ProPauseWork> proPauseWorks = this.selectProPauseWorkList(proPauseWork);

        if (proPauseWorks.size() == 0) {
            ProPauseWork pro = new ProPauseWork();
            pro.setTaskId(proTask.getTaskId());
            pro.setTaskWorkunitId(proTask.getTaskWorkunitId());
            pro.setWorkunitId(proTask.getWorkunitId());
            pro.setAbnormalReason(proTask.getAttr1());
            pro.setAbnormalDescribe(proTask.getAttr2());
            pro.setPauseNum(1L);
            pro.setPauseType(0L);
            pro.setUpdateBy(SecurityUtils.getUsername());
            pro.setUpdateTime(DateUtils.getNowDate());
            proPauseWorkMapper.insertProPauseWork(pro);
        } else {
            List<Long> longs = new ArrayList<>();
            int i = 0;
            for (ProPauseWork pro : proPauseWorks) {
                if (Objects.isNull(pro.getPauseType())) {
                    continue;
                }
                if (pro.getPauseType() == 0) {
                    i++;
                    longs.add(pro.getPauseNum());
                }
            }
            if (i == 0) {
                ProPauseWork pro = new ProPauseWork();
                pro.setTaskId(proTask.getTaskId());
                pro.setTaskWorkunitId(proTask.getTaskWorkunitId());
                pro.setWorkunitId(proTask.getWorkunitId());
                pro.setAbnormalReason(proTask.getAttr1());
                pro.setAbnormalDescribe(proTask.getAttr2());
                pro.setPauseNum(1L);
                pro.setPauseType(0L);
                pro.setUpdateBy(SecurityUtils.getUsername());
                pro.setUpdateTime(DateUtils.getNowDate());
                proPauseWorkMapper.insertProPauseWork(pro);
            } else {
                Long max1 = Collections.max(longs);
                ProPauseWork pro = new ProPauseWork();
                pro.setTaskId(proTask.getTaskId());
                pro.setTaskWorkunitId(proTask.getTaskWorkunitId());
                pro.setWorkunitId(proTask.getWorkunitId());
                pro.setAbnormalReason(proTask.getAttr1());
                pro.setAbnormalDescribe(proTask.getAttr2());
                pro.setPauseNum(max1 + 1);
                pro.setPauseType(0L);
                pro.setUpdateBy(SecurityUtils.getUsername());
                pro.setUpdateTime(DateUtils.getNowDate());
                proPauseWorkMapper.insertProPauseWork(pro);
            }
        }

    }

    /**
     * 异常报告暂停记记录
     *
     * @param qcAbnormalReport
     */
    @Override
    public void insertProTaskWorkunitAbnormal(QcAbnormalReport qcAbnormalReport) {
        ProPauseWork proPauseWork = new ProPauseWork();
        proPauseWork.setTaskId(qcAbnormalReport.getTaskId());
        List<ProPauseWork> proPauseWorks = this.selectProPauseWorkList(proPauseWork);
        if (proPauseWorks.size() == 0) {
            ProPauseWork pro = new ProPauseWork();
            pro.setTaskId(qcAbnormalReport.getTaskId());
            pro.setTaskWorkunitId(qcAbnormalReport.getTaskWorkunitId());
            pro.setWorkunitId(qcAbnormalReport.getWorkstationId());
            pro.setAbnormalReason(qcAbnormalReport.getAbnormalType());
            pro.setAbnormalDescribe(qcAbnormalReport.getAbnormalReason());
            pro.setPauseNum(1L);
            pro.setPauseType(1L);
            pro.setUpdateBy(SecurityUtils.getUsername());
            pro.setUpdateTime(DateUtils.getNowDate());
            proPauseWorkMapper.insertProPauseWork(pro);
        } else {
            List<Long> longs = new ArrayList<>();
            int i = 0;
            for (ProPauseWork pro : proPauseWorks) {
                System.out.println(pro.getPauseType());
                if (pro.getPauseType() == null) {
                    continue;
                }
                if (pro.getPauseType() == 1) {
                    i++;
                    longs.add(pro.getPauseNum());
                }
            }
            if (i == 0) {
                ProPauseWork pro = new ProPauseWork();
                pro.setTaskId(qcAbnormalReport.getTaskId());
                pro.setTaskWorkunitId(qcAbnormalReport.getTaskWorkunitId());
                pro.setWorkunitId(qcAbnormalReport.getWorkstationId());
                pro.setAbnormalReason(qcAbnormalReport.getAbnormalType());
                pro.setAbnormalDescribe(qcAbnormalReport.getAbnormalReason());
                pro.setPauseNum(1L);
                pro.setPauseType(1L);
                pro.setUpdateBy(SecurityUtils.getUsername());
                pro.setUpdateTime(DateUtils.getNowDate());
                proPauseWorkMapper.insertProPauseWork(pro);
            } else {
                Long max1 = Collections.max(longs);
                ProPauseWork pro = new ProPauseWork();
                pro.setTaskId(qcAbnormalReport.getTaskId());
                pro.setTaskWorkunitId(qcAbnormalReport.getTaskWorkunitId());
                pro.setWorkunitId(qcAbnormalReport.getWorkstationId());
                pro.setAbnormalReason(qcAbnormalReport.getAbnormalType());
                pro.setAbnormalDescribe(qcAbnormalReport.getAbnormalReason());
                pro.setPauseNum(max1 + 1);
                pro.setPauseType(1L);
                pro.setUpdateBy(SecurityUtils.getUsername());
                pro.setUpdateTime(DateUtils.getNowDate());
                proPauseWorkMapper.insertProPauseWork(pro);

            }
        }


    }

}
