package com.ximai.mes.pro.domain.vo;

import com.ximai.common.annotation.Excel;
import com.ximai.mes.pro.domain.prototypeMake.ProPrototypeMakeProcess;
import com.ximai.mes.pro.domain.prototypeMake.ProPrototypeMakeProcessItem;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.math.BigDecimal;
import java.util.List;

/**
 * title:
 * author:ZHT
 * date:2024/1/22
 * description:
 */
@Data
public class ProPrototypeMakeProcessVo {
    /** ID */
    private Long prototypeMakeProcessId;

    /** 样品申请单ID */
    @Excel(name = "样品申请单ID")
    private Long prototypeMakeId;

    /** 记录ID */
    @Excel(name = "记录ID")
    private Long recordId;

    /** 编号 */
    @Excel(name = "编号")
    private int orderNum;

    /** 工序名称 */
    @Excel(name = "工序名称")
    private String processName;

    /** 工序编码 */
    @Excel(name = "工序编码")
    private String processCode;

    /** 工序id */
    private Long processId;

    /** 下一道工序的名称 */
    @Excel(name ="下一道工序的名称")
    private String nextProcessName;


    /** 与下一道工序的关系 */
    @Excel(name = "与下一道工序的关系")
    private String linkType;

    /** 甘特图颜色 */
    private String colorCode;

    /** 准备时间 */
    @Excel(name = "准备时间")
    private Long defaultPreTime;

    /** 等待时间 */
    @Excel(name = "等待时间")
    private Long defaultSufTime;

    /** 关键工序 */
    @Excel(name = "关键工序")
    private String keyFlag;

    /** 是否检验 */
    @Excel(name = "是否检验")
    private String isCheck;

    /** 工作中心ID */
    @Excel(name = "工作中心ID")
    private Long workstationId;

    /** 工作中心名称 */
    @Excel(name = "工作中心名称")
    private String  workstationName;
    /** 标准工时 */
    @Excel(name = "标准工时")
    private BigDecimal stdWorkingTime;

    /** 备注 */
    private String remark;

    /** 工序物料 */
    private List<ProPrototypeMakeProcessItem> processItemList;

    private List<ProPrototypeMakeProcessQcindexVo> qcindexList;

    private List<ProPrototypeMakeProcessToolVo> toolList;

    public ProPrototypeMakeProcess getPrototypeMakeProcess(ProPrototypeMakeProcessVo proPrototypeMakeProcessVo) {
        ProPrototypeMakeProcess proPrototypeMakeProcess = new ProPrototypeMakeProcess();
        BeanUtils.copyProperties(proPrototypeMakeProcessVo,proPrototypeMakeProcess);
        return proPrototypeMakeProcess;
    }
}
