package com.ximai.mes.pro.controller;

import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.pro.domain.ProRecoilMaterial;
import com.ximai.mes.pro.service.IProRecoilMaterialService;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 反冲料登记Controller
 *
 * @author generator
 * @date 2024-02-22
 */
@RestController
@RequestMapping("/pro/recoilMaterial")
public class ProRecoilMaterialController extends BaseController {

    @Autowired
    private IProRecoilMaterialService proRecoilMaterialService;

    @ApiOperation(value = "反冲料登记")
    @GetMapping("/getRecoilMaterialList")
    public AjaxResult getRecoilMaterialList(@RequestParam("taskId") Long taskId, @RequestParam("processId") Long processId) {
        return AjaxResult.success(proRecoilMaterialService.getRecoilMaterialList(taskId));
    }

    /**
     * 查询反冲料登记列表
     */
    @PreAuthorize("@ss.hasPermi('pro:recoilMaterial:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProRecoilMaterial proRecoilMaterial) {
        startPage();
        List<ProRecoilMaterial> list = proRecoilMaterialService.selectProRecoilMaterialList(proRecoilMaterial);
        return getDataTable(list);
    }


    /**
     * 获取反冲料登记详细信息
     */
    @PreAuthorize("@ss.hasPermi('pro:recoilMaterial:query')")
    @GetMapping(value = "/{recoilMaterialId}")
    public AjaxResult getInfo(@PathVariable("recoilMaterialId") Long recoilMaterialId) {
        return AjaxResult.success(proRecoilMaterialService.selectProRecoilMaterialById(recoilMaterialId));
    }

    /**
     * 新增反冲料登记
     */
    @PreAuthorize("@ss.hasPermi('pro:recoilMaterial:add')")
    @Log(title = "反冲料登记", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProRecoilMaterial proRecoilMaterial) {
        return toAjax(proRecoilMaterialService.insertProRecoilMaterial(proRecoilMaterial));
    }

    /**
     * 修改反冲料登记
     */
    @PreAuthorize("@ss.hasPermi('pro:recoilMaterial:edit')")
    @Log(title = "反冲料登记", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProRecoilMaterial proRecoilMaterial) {
        return toAjax(proRecoilMaterialService.updateProRecoilMaterial(proRecoilMaterial));
    }

    /**
     * 删除反冲料登记
     */
    @PreAuthorize("@ss.hasPermi('pro:recoilMaterial:remove')")
    @Log(title = "反冲料登记", businessType = BusinessType.DELETE)
    @DeleteMapping("/{recoilMaterialIds}")
    public AjaxResult remove(@PathVariable Long[] recoilMaterialIds) {
        return toAjax(proRecoilMaterialService.deleteProRecoilMaterialByIds(recoilMaterialIds));
    }
}
