package com.ximai.mes.md.service.impl;

import java.util.List;

import cn.hutool.core.bean.BeanUtil;
import com.ximai.common.constant.UserConstants;
import com.ximai.common.utils.data.DateUtils;
import com.ximai.mes.md.vo.MdVehicleExcel;
import com.ximai.system.strategy.AutoCodeUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.md.mapper.MdVehicleMapper;
import com.ximai.mes.md.domain.MdVehicle;
import com.ximai.mes.md.service.IMdVehicleService;
import org.springframework.web.multipart.MultipartFile;

/**
 * 车辆列表Service业务层处理
 *
 * @author generator
 * @date 2024-01-25
 */
@Service
public class MdVehicleServiceImpl implements IMdVehicleService
{
    @Autowired
    private MdVehicleMapper mdVehicleMapper;
    @Autowired
    private AutoCodeUtil autoCodeUtil;

    /**
     * 查询车辆列表
     *
     * @param vehicleId 车辆列表主键
     * @return 车辆列表
     */
    @Override
    public MdVehicle selectMdVehicleByVehicleId(Long vehicleId)
    {
        return mdVehicleMapper.selectMdVehicleByVehicleId(vehicleId);
    }

    /**
     * 查询车辆列表列表
     *
     * @param mdVehicle 车辆列表
     * @return 车辆列表
     */
    @Override
    public List<MdVehicle> selectMdVehicleList(MdVehicle mdVehicle)
    {
        return mdVehicleMapper.selectMdVehicleList(mdVehicle);
    }

    /**
     * 新增车辆列表
     *
     * @param mdVehicle 车辆列表
     * @return 结果
     */
    @Override
    public int insertMdVehicle(MdVehicle mdVehicle)
    {
        mdVehicle.setCreateTime(DateUtils.getNowDate());
        String code = autoCodeUtil.genSerialCode(UserConstants.VEHICLE_CODE, null);
        mdVehicle.setVehicleCode(code);
        return mdVehicleMapper.insertMdVehicle(mdVehicle);
    }

    /**
     * 修改车辆列表
     *
     * @param mdVehicle 车辆列表
     * @return 结果
     */
    @Override
    public int updateMdVehicle(MdVehicle mdVehicle)
    {
        mdVehicle.setUpdateTime(DateUtils.getNowDate());
        return mdVehicleMapper.updateMdVehicle(mdVehicle);
    }

    /**
     * 批量删除车辆列表
     *
     * @param vehicleIds 需要删除的车辆列表主键
     * @return 结果
     */
    @Override
    public int deleteMdVehicleByVehicleIds(Long[] vehicleIds)
    {
        return mdVehicleMapper.deleteMdVehicleByVehicleIds(vehicleIds);
    }

    /**
     * 删除车辆列表信息
     *
     * @param vehicleId 车辆列表主键
     * @return 结果
     */
    @Override
    public int deleteMdVehicleByVehicleId(Long vehicleId)
    {
        return mdVehicleMapper.deleteMdVehicleByVehicleId(vehicleId);
    }

    @Override
    public void importVehicle(MultipartFile file, Boolean isUpdateSupport, String operName) throws Exception {

    }
}
