package com.ximai.mes.md.service.impl;

import com.ximai.mes.md.domain.MdFactory;
import com.ximai.mes.md.mapper.MdFactoryMapper;
import com.ximai.mes.md.service.IMdFactoryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 工厂Service业务层处理
 *
 * @author yinjinlu
 * @date 2024-01-18
 */
@Service
public class MdFactoryServiceImpl implements IMdFactoryService {
    @Autowired
    private MdFactoryMapper mdFactoryMapper;

    /**
     * 查询工厂
     *
     * @param factoryId 工厂主键
     * @return 工厂
     */
    @Override
    public MdFactory selectMdFactoryByFactoryId(Long factoryId) {
        return mdFactoryMapper.selectMdFactoryByFactoryId(factoryId);
    }

    /**
     * 查询工厂列表
     *
     * @param mdFactory 工厂
     * @return 工厂
     */
    @Override
    public List<MdFactory> selectMdFactoryList(MdFactory mdFactory) {
        return mdFactoryMapper.selectMdFactoryList(mdFactory);
    }

    /**
     * 新增工厂
     *
     * @param mdFactory 工厂
     * @return 结果
     */
    @Override
    public int insertMdFactory(MdFactory mdFactory) {
        mdFactory.createAction();
        return mdFactoryMapper.insertMdFactory(mdFactory);
    }

    /**
     * 修改工厂
     *
     * @param mdFactory 工厂
     * @return 结果
     */
    @Override
    public int updateMdFactory(MdFactory mdFactory) {
        mdFactory.updateAction();
        return mdFactoryMapper.updateMdFactory(mdFactory);
    }

    /**
     * 批量删除工厂
     *
     * @param factoryIds 需要删除的工厂主键
     * @return 结果
     */
    @Override
    public int deleteMdFactoryByFactoryIds(Long[] factoryIds) {
        return mdFactoryMapper.deleteMdFactoryByFactoryIds(factoryIds);
    }

    /**
     * 删除工厂信息
     *
     * @param factoryId 工厂主键
     * @return 结果
     */
    @Override
    public int deleteMdFactoryByFactoryId(Long factoryId) {
        return mdFactoryMapper.deleteMdFactoryByFactoryId(factoryId);
    }
}
