package com.ximai.mes.md.service;

import java.util.List;
import com.ximai.mes.md.domain.MdProductPublishedConf;

/**
 * 产品打样排版参数配置Service接口
 *
 * @author yinjinlu
 * @date 2024-01-17
 */
public interface IMdProductPublishedConfService
{
    /**
     * 查询产品打样排版参数配置
     *
     * @param itemId 产品打样排版参数配置主键
     * @return 产品打样排版参数配置
     */
    public MdProductPublishedConf selectMdProductPublishedConfByItemId(Long itemId);

    /**
     * 查询产品打样排版参数配置列表
     *
     * @param mdProductPublishedConf 产品打样排版参数配置
     * @return 产品打样排版参数配置集合
     */
    public List<MdProductPublishedConf> selectMdProductPublishedConfList(MdProductPublishedConf mdProductPublishedConf);

    /**
     * 新增产品打样排版参数配置
     *
     * @param mdProductPublishedConf 产品打样排版参数配置
     * @return 结果
     */
    public int insertMdProductPublishedConf(MdProductPublishedConf mdProductPublishedConf);

    /**
     * 修改产品打样排版参数配置
     *
     * @param mdProductPublishedConf 产品打样排版参数配置
     * @return 结果
     */
    public int updateMdProductPublishedConf(MdProductPublishedConf mdProductPublishedConf);

    /**
     * 批量删除产品打样排版参数配置
     *
     * @param itemIds 需要删除的产品打样排版参数配置主键集合
     * @return 结果
     */
    public int deleteMdProductPublishedConfByItemIds(Long[] itemIds);

    /**
     * 删除产品打样排版参数配置信息
     *
     * @param itemId 产品打样排版参数配置主键
     * @return 结果
     */
    public int deleteMdProductPublishedConfByItemId(Long itemId);
}
