package com.ximai.mes.cal.service.impl;

import cn.hutool.core.date.DateUtil;
import com.ximai.common.utils.data.DateUtils;
import com.ximai.mes.cal.domain.CalHoliday;
import com.ximai.mes.cal.domain.CalPlanWorkunit;
import com.ximai.mes.cal.mapper.CalHolidayMapper;
import com.ximai.mes.cal.service.ICalHolidayService;
import com.ximai.mes.cal.service.ICalPlanWorkunitService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 节假日设置Service业务层处理
 *
 * @date 2022-06-08
 */
@Service
public class CalHolidayServiceImpl implements ICalHolidayService {
    @Autowired
    private CalHolidayMapper calHolidayMapper;
    @Autowired
    private ICalPlanWorkunitService calPlanWorkunitService;

    /**
     * 查询节假日设置
     *
     * @param holidayId 节假日设置主键
     * @return 节假日设置
     */
    @Override
    public CalHoliday selectCalHolidayByHolidayId(Long holidayId) {
        return calHolidayMapper.selectCalHolidayByHolidayId(holidayId);
    }

    /**
     * 查询节假日设置列表
     *
     * @param calHoliday 节假日设置
     * @return 节假日设置
     */
    @Override
    public List<CalHoliday> selectCalHolidayList(CalHoliday calHoliday) {
        List<CalHoliday> calHolidays = calHolidayMapper.selectCalHolidayList(calHoliday);
        for (CalHoliday holiday : calHolidays) {
            String theDayStr = DateUtil.format(holiday.getTheDay(), "yyyy-MM-dd");
            CalPlanWorkunit calPlanWorkunit = new CalPlanWorkunit();
            calPlanWorkunit.setTheDay(theDayStr);
            List<CalPlanWorkunit> calPlanWorkunits = calPlanWorkunitService.selectCalPlanWorkunitList(calPlanWorkunit);
            if (calPlanWorkunits.size() > 0) {
                // 当天无排班
                holiday.setScheduling(2);
                holiday.setHolidayType("WORKDAY");
            } else {
                // 当天有排班
                holiday.setScheduling(1);
                holiday.setHolidayType("HOLIDAY");
            }
        }
        return calHolidays;
    }

    /**
     * 新增节假日设置
     *
     * @param calHoliday 节假日设置
     * @return 结果
     */
    @Override
    public int insertCalHoliday(CalHoliday calHoliday) {
        calHoliday.setCreateTime(DateUtils.getNowDate());
        return calHolidayMapper.insertCalHoliday(calHoliday);
    }

    /**
     * 修改节假日设置
     *
     * @param calHoliday 节假日设置
     * @return 结果
     */
    @Override
    public int updateCalHoliday(CalHoliday calHoliday) {
        calHoliday.setUpdateTime(DateUtils.getNowDate());
        return calHolidayMapper.updateCalHoliday(calHoliday);
    }

    /**
     * 批量删除节假日设置
     *
     * @param holidayIds 需要删除的节假日设置主键
     * @return 结果
     */
    @Override
    public int deleteCalHolidayByHolidayIds(Long[] holidayIds) {
        return calHolidayMapper.deleteCalHolidayByHolidayIds(holidayIds);
    }

    /**
     * 删除节假日设置信息
     *
     * @param holidayId 节假日设置主键
     * @return 结果
     */
    @Override
    public int deleteCalHolidayByHolidayId(Long holidayId) {
        return calHolidayMapper.deleteCalHolidayByHolidayId(holidayId);
    }
}
