package com.ximai.mes.remote.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 工序完工（转移单创建）
 *
 * @author generator
 * @date 2025-10-12
 */
@Data
public class ProcessTransferCreate {

    @ApiModelProperty("转移单别")
    @JsonProperty("tb001")
    private String transferType = "D20";

    @ApiModelProperty("移出地")
    @JsonProperty("tb005")
    private String fromLocation;

    @ApiModelProperty("移出地名称")
    @JsonProperty("tb006")
    private String fromLocationName;

    @ApiModelProperty("移入地")
    @JsonProperty("tb008")
    private String toLocation;

    @ApiModelProperty("移入地名称")
    @JsonProperty("tb009")
    private String toLocationName;

    @ApiModelProperty("工单单别")
    @JsonProperty("tc004")
    private String workOrderType;

    @ApiModelProperty("工单单号")
    @JsonProperty("tc005")
    private String workOrderNo;

    @ApiModelProperty("移出加工顺序")
    @JsonProperty("tc006")
    private String fromProcessSeq;

    @ApiModelProperty("移出加工顺序名称")
    @JsonProperty("tc007")
    private String fromProcessName;

    @ApiModelProperty("移入加工顺序")
    @JsonProperty("tc008")
    private String toProcessSeq;

    @ApiModelProperty("移入加工顺序名称")
    @JsonProperty("tc009")
    private String toProcessName;

    @ApiModelProperty("类型")
    @JsonProperty("tc013")
    private String type;

    @ApiModelProperty("使用人时")
    @JsonProperty("tc020")
    private Integer manHours;

    @ApiModelProperty("使用机时")
    @JsonProperty("tc021")
    private Integer machineHours;

    @ApiModelProperty("转移数量")
    @JsonProperty("tc036")
    private BigDecimal transferQty;
}

