package com.ximai.mes.remote.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.ximai.mes.config.EmptyStringToLongDeserializer;
import com.ximai.mes.config.TrimStringDeserializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 物料对象 MdItemErpDto
 *
 * @date 2024-10-18
 */
@Data
public class MdItemTypeErpDto
{
    private static final long serialVersionUID = 1L;

    @JsonProperty("ma002")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    @ApiModelProperty("品号类别编号")
    private String itemTypeCode;

    @JsonProperty("ma003")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    @ApiModelProperty("品号类别名称")
    private String itemTypeName;

}
