package com.ximai.mes.pro.service.impl.productionSolution;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.common.core.domain.entity.SysUser;
import com.ximai.common.utils.data.DataUtil;
import com.ximai.mes.pro.domain.productionSolution.ProProductionSolutionSpecificationSheet;
import com.ximai.mes.pro.mapper.productionSolution.ProProductionSolutionSpecificationSheetMapper;
import com.ximai.mes.pro.service.proWorkOrder.IProWorkorderService;
import com.ximai.mes.pro.service.productionSolution.IProProductionSolutionSpecificationSheetService;
import com.ximai.system.service.ISysDictDataService;
import com.ximai.system.service.ISysUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 生产方案规格书Service业务层处理
 *
 * @author zht
 * @date 2024-03-23
 */
@Service
public class ProProductionSolutionSpecificationSheetServiceImpl implements IProProductionSolutionSpecificationSheetService {
    @Autowired
    private ProProductionSolutionSpecificationSheetMapper proProductionSolutionSpecificationSheetMapper;

    @Autowired
    private ISysDictDataService dictDataService;


    @Autowired
    private IProWorkorderService proWorkorderService;

    @Autowired
    private ISysUserService iSysUserService;

    /**
     * 查询生产方案规格书
     *
     * @param specificationSheetId 生产方案规格书主键
     * @return 生产方案规格书
     */
    @Override
    public ProProductionSolutionSpecificationSheet selectProProductionSolutionSpecificationSheetBySpecificationSheetId(Long specificationSheetId) {
        return proProductionSolutionSpecificationSheetMapper.selectProProductionSolutionSpecificationSheetBySpecificationSheetId(specificationSheetId);
    }

    /**
     * 查询生产方案规格书列表
     *
     * @param proProductionSolutionSpecificationSheet 生产方案规格书
     * @return 生产方案规格书
     */
    @Override
    public List<ProProductionSolutionSpecificationSheet> selectProProductionSolutionSpecificationSheetList(ProProductionSolutionSpecificationSheet proProductionSolutionSpecificationSheet) {
        return proProductionSolutionSpecificationSheetMapper.selectProProductionSolutionSpecificationSheetList(proProductionSolutionSpecificationSheet);
    }

    /**
     * 新增生产方案规格书
     *
     * @param proProductionSolutionSpecificationSheet 生产方案规格书
     * @return 结果
     */
    @Override
    public int insertProProductionSolutionSpecificationSheet(ProProductionSolutionSpecificationSheet proProductionSolutionSpecificationSheet) {
        return proProductionSolutionSpecificationSheetMapper.insertProProductionSolutionSpecificationSheet(proProductionSolutionSpecificationSheet);
    }

    /**
     * 修改生产方案规格书
     *
     * @param proProductionSolutionSpecificationSheet 生产方案规格书
     * @return 结果
     */
    @Override
    public int updateProProductionSolutionSpecificationSheet(ProProductionSolutionSpecificationSheet proProductionSolutionSpecificationSheet) {
        return proProductionSolutionSpecificationSheetMapper.updateProProductionSolutionSpecificationSheet(proProductionSolutionSpecificationSheet);
    }

    /**
     * 批量删除生产方案规格书
     *
     * @param specificationSheetIds 需要删除的生产方案规格书主键
     * @return 结果
     */
    @Override
    public int deleteProProductionSolutionSpecificationSheetBySpecificationSheetIds(Long[] specificationSheetIds) {
        return proProductionSolutionSpecificationSheetMapper.deleteProProductionSolutionSpecificationSheetBySpecificationSheetIds(specificationSheetIds);
    }

    /**
     * 删除生产方案规格书信息
     *
     * @param specificationSheetId 生产方案规格书主键
     * @return 结果
     */
    @Override
    public int deleteProProductionSolutionSpecificationSheetBySpecificationSheetId(Long specificationSheetId) {
        return proProductionSolutionSpecificationSheetMapper.deleteProProductionSolutionSpecificationSheetBySpecificationSheetId(specificationSheetId);
    }

    @Override
    public ProProductionSolutionSpecificationSheet selectSpecificationSheetByProductionSolutionId(Long productionSolutionId) {
        return proProductionSolutionSpecificationSheetMapper.selectSpecificationSheetByProductionSolutionId(productionSolutionId);
    }

    @Override
    public ProProductionSolutionSpecificationSheet getInfoByWorkorderId(Long workorderId) {
        ProProductionSolutionSpecificationSheet sheet = proProductionSolutionSpecificationSheetMapper.selectByWorkOrderId(workorderId);
        if (sheet == null) {
            return new ProProductionSolutionSpecificationSheet();
        }

        List<String> useids = new ArrayList<>();
        String rdPreparedBy = sheet.getRdPreparedBy();
        String rdApprovedBy = sheet.getRdApprovedBy();
        String rdReviewedBy = sheet.getRdReviewedBy();
        useids.add(rdPreparedBy);
        useids.add(rdApprovedBy);
        useids.add(rdReviewedBy);
        List<String> userIds2 = useids.stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(userIds2)) {
            QueryWrapper<SysUser> sysUserQueryWrapper = new QueryWrapper<>();
            sysUserQueryWrapper.in("user_name", userIds2);
            List<SysUser> sysUsers = iSysUserService.selectListByQw(sysUserQueryWrapper);

            Map<Long, String> userMap = sysUsers.stream().collect(Collectors.toMap(SysUser::getUserId, x -> x.getNickName() == null ? x.getUserName() : x.getNickName()));

            sheet.setRdPreparedByStr(DataUtil.getNormalData(userMap.get(rdPreparedBy)));
            sheet.setRdApprovedByStr(DataUtil.getNormalData(userMap.get(rdApprovedBy)));
            sheet.setRdReviewedByStr(DataUtil.getNormalData(userMap.get(rdReviewedBy)));
        }

        
        String shape = sheet.getShape();
        if (shape != null) {
            sheet.setShapeStr(dictDataService.getDictLabel("product_shape", shape));
        }

        String sheetType = sheet.getSpecificationSheetType();
        if (sheetType != null) {
            sheet.setSpecificationSheetTypeStr(dictDataService.getDictLabel("specification_sheet_type", sheetType));
        }
        return sheet;

    }
}
