package com.ximai.mes.pro.mapper.productionMake;

import java.util.List;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.pro.domain.productionMake.ProProductionMake;
import com.ximai.mes.pro.domain.vo.ProProductionMakeVo;
import org.apache.ibatis.annotations.Param;

/**
 * 量产制作Mapper接口
 *
 * @author chicheng.li
 * @date 2024-01-23
 */
public interface ProProductionMakeMapper extends BaseMapper<ProProductionMake>
{
    /**
     * 查询量产制作
     *
     * @param productionMakeId 量产制作主键
     * @return 量产制作
     */
    public ProProductionMakeVo selectProProductionMakeByProductionMakeId(Long productionMakeId);

    /**
     * 查询量产制作列表
     *
     * @param proProductionMake 量产制作
     * @return 量产制作集合
     */
    public List<ProProductionMakeVo> selectProProductionMakeList(ProProductionMake proProductionMake);

    /**
     * 新增量产制作
     *
     * @param proProductionMake 量产制作
     * @return 结果
     */
    public int insertProProductionMake(ProProductionMake proProductionMake);

    /**
     * 修改量产制作
     *
     * @param proProductionMake 量产制作
     * @return 结果
     */
    public int updateProProductionMake(ProProductionMake proProductionMake);

    /**
     * 删除量产制作
     *
     * @param productionMakeId 量产制作主键
     * @return 结果
     */
    public int deleteProProductionMakeByProductionMakeId(Long productionMakeId);

    /**
     * 批量删除量产制作
     *
     * @param productionMakeIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteProProductionMakeByProductionMakeIds(Long[] productionMakeIds);

    public int updateProProductionMakeStatus(@Param("productionMakeId") Long productionMakeId, @Param("productionMakeStatus") int productionMakeStatus);

}
