package com.ximai.mes.pro.mapper;

import com.ximai.mes.pro.domain.ProBom;

import java.util.List;

/**
 * BOMMapper接口
 *
 * @author zht
 * @date 2024-01-16
 */
public interface ProBomMapper
{
    /**
     * 查询BOM
     *
     * @param bomId BOM主键
     * @return BOM
     */
    public ProBom selectProBomByBomId(Long bomId);

    /**
     * 查询BOM列表
     *
     * @param proBom BOM
     * @return BOM集合
     */
    public List<ProBom> selectProBomList(ProBom proBom);

    /**
     * 新增BOM
     *
     * @param proBom BOM
     * @return 结果
     */
    public int insertProBom(ProBom proBom);

    /**
     * 修改BOM
     *
     * @param proBom BOM
     * @return 结果
     */
    public int updateProBom(ProBom proBom);

    /**
     * 删除BOM
     *
     * @param bomId BOM主键
     * @return 结果
     */
    public int deleteProBomByBomId(Long bomId);

    /**
     * 批量删除BOM
     *
     * @param bomIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteProBomByBomIds(Long[] bomIds);
}
