package com.ximai.mes.pro.controller;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import com.ximai.mes.pro.domain.ProStorageDetailRecord;
import com.ximai.mes.pro.dto.ProStorageDetailRecordDto;
import com.ximai.mes.pro.dto.ProStorageDetailRecordQuery;
import com.ximai.mes.pro.dto.ProStorageDetailRecordCreate;
import com.ximai.mes.pro.dto.ProStorageDetailRecordUpdate;
import com.ximai.mes.pro.service.IProStorageDetailRecordService;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 入库明细记录Controller
 *
 * @author generator
 * @date 2025-10-12
 */
@Api(tags = "入库明细记录")
@RestController
@RequestMapping("/pro/storageDetailRecord")
public class ProStorageDetailRecordController extends BaseController
{
    @Autowired
    private IProStorageDetailRecordService proStorageDetailRecordService;

    /**
     * 查询入库明细记录列表
     */
    @ApiOperation("查询入库明细记录列表")
    @PreAuthorize("@ss.hasPermi('pro:storageDetailRecord:list')")
    @GetMapping("/list")
    public TableDataInfo<ProStorageDetailRecordDto> list(ProStorageDetailRecordQuery proStorageDetailRecordQuery) {
        startPage();
        ProStorageDetailRecord query = new ProStorageDetailRecord();
        if (StringUtils.isNotEmpty(proStorageDetailRecordQuery.getWorkOrderType())) {
            query.setWorkOrderType(proStorageDetailRecordQuery.getWorkOrderType());
        }
        if (StringUtils.isNotEmpty(proStorageDetailRecordQuery.getWorkOrderNo())) {
            query.setWorkOrderNo(proStorageDetailRecordQuery.getWorkOrderNo());
        }
        if (StringUtils.isNotEmpty(proStorageDetailRecordQuery.getBoxCode())) {
            query.setBoxCode(proStorageDetailRecordQuery.getBoxCode());
        }
        if (StringUtils.isNotEmpty(proStorageDetailRecordQuery.getLabelNo())) {
            query.setLabelNo(proStorageDetailRecordQuery.getLabelNo());
        }
        List<ProStorageDetailRecordDto> list = proStorageDetailRecordService.selectProStorageDetailRecordList(query);
        return getDataTable(list);
    }

    /**
     * 获取入库明细记录详细信息
     */
    @ApiOperation("获取入库明细记录详细信息")
    @PreAuthorize("@ss.hasPermi('pro:storageDetailRecord:query')")
    @GetMapping(value = "/{recordId}")
    public AjaxResult<ProStorageDetailRecordDto> getInfo(@PathVariable("recordId") Long recordId) {
        return AjaxResult.success(proStorageDetailRecordService.selectProStorageDetailRecordDtoByRecordId(recordId));
    }

    /**
     * 根据箱码查询入库明细记录列表
     */
    @ApiOperation("根据箱码查询入库明细记录列表")
    @PreAuthorize("@ss.hasPermi('pro:storageDetailRecord:query')")
    @GetMapping("/boxCode/{boxCode}")
    public AjaxResult<List<ProStorageDetailRecordDto>> getByBoxCode(@PathVariable("boxCode") String boxCode) {
        List<ProStorageDetailRecordDto> list = proStorageDetailRecordService.selectProStorageDetailRecordByBoxCode(boxCode);
        return AjaxResult.success(list);
    }

    /**
     * 新增入库明细记录
     */
    @ApiOperation("新增入库明细记录")
    @PreAuthorize("@ss.hasPermi('pro:storageDetailRecord:add')")
    @Log(title = "入库明细记录", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProStorageDetailRecordCreate proStorageDetailRecordCreate) {
        return toAjax(proStorageDetailRecordService.insertProStorageDetailRecord(proStorageDetailRecordCreate));
    }

    /**
     * 新增入库明细记录（内部调用，无权限验证）
     * 供 ERP 系统通过 OpenFeign 调用
     */
    @ApiOperation("新增入库明细记录（内部接口）")
    @Log(title = "入库明细记录（内部）", businessType = BusinessType.INSERT)
    @PostMapping("/internal")
    public AjaxResult addInternal(@RequestBody ProStorageDetailRecordCreate proStorageDetailRecordCreate) {
        return toAjax(proStorageDetailRecordService.insertProStorageDetailRecord(proStorageDetailRecordCreate));
    }

    /**
     * 修改入库明细记录
     */
    @ApiOperation("修改入库明细记录")
    @PreAuthorize("@ss.hasPermi('pro:storageDetailRecord:edit')")
    @Log(title = "入库明细记录", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProStorageDetailRecordUpdate proStorageDetailRecordUpdate) {
        return toAjax(proStorageDetailRecordService.updateProStorageDetailRecord(proStorageDetailRecordUpdate));
    }

    /**
     * 删除入库明细记录
     */
    @ApiOperation("删除入库明细记录")
    @PreAuthorize("@ss.hasPermi('pro:storageDetailRecord:remove')")
    @Log(title = "入库明细记录", businessType = BusinessType.DELETE)
	@DeleteMapping("/{recordIds}")
    public AjaxResult remove(@PathVariable Long[] recordIds) {
        return toAjax(proStorageDetailRecordService.deleteProStorageDetailRecordByRecordIds(recordIds));
    }
}

