package com.ximai.mes.pro.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import com.ximai.mes.pro.domain.ProBomItem;
import com.ximai.mes.pro.service.IProBomItemService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.common.core.page.TableDataInfo;

/**
 * BOM组件Controller
 *
 * @author yinjinlu
 * @date 2024-01-16
 */
@RestController
@RequestMapping("/mes/pro/bomItem")
public class ProBomItemController extends BaseController
{
    @Autowired
    private IProBomItemService proBomItemService;

    /**
     * 查询BOM组件列表
     */
    @GetMapping("/list")
    public TableDataInfo list(ProBomItem proBomItem)
    {
        startPage();
        List<ProBomItem> list = proBomItemService.selectProBomItemList(proBomItem);
        return getDataTable(list);
    }

    /**
     * 获取BOM组件详细信息
     */
    @PreAuthorize("@ss.hasPermi('mes:pro:bom:query')")
    @GetMapping(value = "/{bomItemId}")
    public AjaxResult getInfo(@PathVariable("bomItemId") Long bomItemId)
    {
        return AjaxResult.success(proBomItemService.selectProBomItemByBomItemId(bomItemId));
    }

    /**
     * 新增BOM组件
     */
    @PreAuthorize("@ss.hasPermi('mes:pro:bom:add')")
    @Log(title = "BOM组件", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProBomItem proBomItem)
    {
        return toAjax(proBomItemService.insertProBomItem(proBomItem));
    }

    /**
     * 修改BOM组件
     */
    @PreAuthorize("@ss.hasPermi('mes:pro:bom:edit')")
    @Log(title = "BOM组件", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProBomItem proBomItem)
    {
        return toAjax(proBomItemService.updateProBomItem(proBomItem));
    }

    /**
     * 删除BOM组件
     */
    @PreAuthorize("@ss.hasPermi('mes:pro:bom:remove')")
    @Log(title = "BOM组件", businessType = BusinessType.DELETE)
	@DeleteMapping("/{bomItemIds}")
    public AjaxResult remove(@PathVariable Long[] bomItemIds)
    {
        return toAjax(proBomItemService.deleteProBomItemByBomItemIds(bomItemIds));
    }
}
