package com.ximai.mes.md.service;

import com.ximai.mes.md.domain.MdBaseInfo;
import com.ximai.mes.md.vo.MdBaseInfoVo;

/**
 * 产品基本信息Service接口
 *
 * @author yinjinlu
 * @date 2024-01-16
 */
public interface IMdBaseInfoService
{
    /**
     * 查询产品基本信息
     *
     * @param itemId 产品基本信息主键
     * @return 产品基本信息
     */
    public MdBaseInfoVo selectMdBaseInfoByItemId(Long itemId);

    /**
     * 新增产品基本信息
     *
     * @param mdBaseInfo 产品基本信息
     * @return 结果
     */
    public int insertMdBaseInfo(MdBaseInfo mdBaseInfo);

    /**
     * 修改产品基本信息
     *
     * @param mdBaseInfo 产品基本信息
     * @return 结果
     */
    public int updateMdBaseInfo(MdBaseInfo mdBaseInfo);

    /**
     * 删除产品基本信息信息
     *
     * @param itemId 产品基本信息主键
     * @return 结果
     */
    public int deleteMdBaseInfoByItemId(Long itemId);

}
