package com.ximai.mes.md.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

/**
 * 产品基本信息对象 md_base_info
 *
 * @author yinjinlu
 * @date 2024-01-16
 */

@ToString
@Data
public class MdBaseInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 产品id */
    @Excel(name = "产品id")
    private Long itemId;

    /** 产品代号 */
    @Excel(name = "产品代号")
    private String productNo;

    /** 英文名称 */
    @Excel(name = "英文名称")
    private String productEnglishName;


    /** 计量单位 */
    @Excel(name = "计量单位")
    private String unitOfMeasure;

    /** 有效开始日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "有效开始日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date expirationDateStart;

    /** 有效结束日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "有效结束日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date expirationDateEnd;



    /** 品牌编码 */
    @Excel(name = "品牌编码")
    private String brandCode;

    /** 品牌名称 */
    private String brandName;

    /** 尺码组id */
    @Excel(name = "尺码组id")
    private Long sizeGroupId;

    /** 尺码组名称 */
    private String sizeGroupName;

    /** 版面(product_layout) */
    @Excel(name = "版面(layout)")
    private String layout;


    /** 物料类型 */
    @Excel(name = "物料类型")
    private String materialType;

    /** 产品组 */
    @Excel(name = "产品组")
    private String productGroup;

    /** 毛重 */
    @Excel(name = "毛重")
    private String grossWeight;

    /** 净重 */
    @Excel(name = "净重")
    private String netWeight;

    /** 重量单位 */
    @Excel(name = "重量单位")
    private String weightUnit;

    /** 体积 */
    @Excel(name = "体积")
    private String volume;

    /**
     * 是否排版
     */
    private String isLayout;

    /** 体积 */
    @Excel(name = "体积")
    private String volumeUnit;

    @ApiModelProperty("包装数量")
    private String packageNum;

    @ApiModelProperty("装箱数量")
    private String encasementNum;

}
