package com.ximai.mes.cal.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.cal.domain.CalPlanWorkunit;
import com.ximai.mes.cal.domain.CalShift;
import com.ximai.mes.cal.domain.vo.CalShiftVo;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 计划班次Mapper接口
 *
 * @date 2022-06-06
 */
public interface CalShiftMapper {
    /**
     * 查询计划班次
     *
     * @param shiftId 计划班次主键
     * @return 计划班次
     */
    CalShift selectCalShiftByShiftId(Long shiftId);

    /**
     * 查询计划班次列表
     *
     * @param calShift 计划班次
     * @return 计划班次集合
     */
    List<CalShift> selectCalShiftList(CalShift calShift);


    int checkShiftCount(Long planId);

    /**
     * 新增计划班次
     *
     * @param calShift 计划班次
     * @return 结果
     */
    int insertCalShift(CalShift calShift);

    /**
     * 修改计划班次
     *
     * @param calShift 计划班次
     * @return 结果
     */
    int updateCalShift(CalShift calShift);

    /**
     * 删除计划班次
     *
     * @param shiftId 计划班次主键
     * @return 结果
     */
    int deleteCalShiftByShiftId(Long shiftId);

    /**
     * 批量删除计划班次
     *
     * @param shiftIds 需要删除的数据主键集合
     * @return 结果
     */
    int deleteCalShiftByShiftIds(Long[] shiftIds);

    int deleteByPlanId(Long planId);


    int deleteByPlanCode(String planCode);

    List<CalShiftVo> selectOnWorkShift(CalPlanWorkunit calPlanWorkunit);

    @Select("select ash.*,mws.workstation_name,mws.workshop_name, cpw.the_day, cpw.workunit_id, cpw.workunit_name, cpw.workunit_code, 1 is_work\n" +
            "from cal_shift ash\n" +
            "         inner join (select shift_name, workunit_id, workunit_code, workunit_name, the_Day, shift_id\n" +
            "                     from cal_plan_workunit where is_work = 1  group by shift_name, workunit_id, workunit_code, workunit_name, the_Day, shift_id) cpw on ash.shift_id = cpw.shift_id left join md_workunit mw on cpw.workunit_id = mw.workunit_id left join md_workstation mws on mw.workstation_id = mws.workstation_id ${ew.customSqlSegment}")
    List<CalShiftVo> selectOnWorkShiftByQw(@Param("ew") QueryWrapper<CalShiftVo> query);


    @Select("select t1.* from cal_shift t1 ${ew.customSqlSegment}")
    List<CalShift> selectListByQw(@Param("ew") QueryWrapper<CalShift> query);

}
