package com.ximai.mes.pro.service.productionRequest;

import java.util.List;
import com.ximai.mes.pro.domain.productionRequest.ProProductionRequestProcessTool;
import com.ximai.mes.pro.domain.vo.ProProductionRequestProcessToolVo;

/**
 * 量产申请工序工装夹具Service接口
 *
 * @author generator
 * @date 2024-01-27
 */
public interface IProProductionRequestProcessToolService
{
    /**
     * 查询量产申请工序工装夹具
     *
     * @param productionRequestProcessToolId 量产申请工序工装夹具主键
     * @return 量产申请工序工装夹具
     */
    public ProProductionRequestProcessTool selectProProductionRequestProcessToolByProductionRequestProcessToolId(Long productionRequestProcessToolId);

    /**
     * 查询量产申请工序工装夹具列表
     *
     * @param proProductionRequestProcessTool 量产申请工序工装夹具
     * @return 量产申请工序工装夹具集合
     */
    public List<ProProductionRequestProcessTool> selectProProductionRequestProcessToolList(ProProductionRequestProcessTool proProductionRequestProcessTool);

    public List<ProProductionRequestProcessToolVo> selectProProductionRequestProcessToolVoList(ProProductionRequestProcessTool proProductionRequestProcessTool);

    /**
     * 新增量产申请工序工装夹具
     *
     * @param proProductionRequestProcessTool 量产申请工序工装夹具
     * @return 结果
     */
    public int insertProProductionRequestProcessTool(ProProductionRequestProcessTool proProductionRequestProcessTool);

    /**
     * 修改量产申请工序工装夹具
     *
     * @param proProductionRequestProcessTool 量产申请工序工装夹具
     * @return 结果
     */
    public int updateProProductionRequestProcessTool(ProProductionRequestProcessTool proProductionRequestProcessTool);

    /**
     * 批量删除量产申请工序工装夹具
     *
     * @param productionRequestProcessToolIds 需要删除的量产申请工序工装夹具主键集合
     * @return 结果
     */
    public int deleteProProductionRequestProcessToolByProductionRequestProcessToolIds(Long[] productionRequestProcessToolIds);

    /**
     * 删除量产申请工序工装夹具信息
     *
     * @param productionRequestProcessToolId 量产申请工序工装夹具主键
     * @return 结果
     */
    public int deleteProProductionRequestProcessToolByProductionRequestProcessToolId(Long productionRequestProcessToolId);
}
