package com.ximai.mes.pro.mapper.task;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.pro.domain.task.ProTask;
import com.ximai.mes.pro.domain.task.ProTaskWorkorder;
import com.ximai.mes.pro.domain.vo.ProTaskWorkorderReportFormListVo;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

/**
 * 任务合并工单Mapper接口
 *
 * @author zht
 * @date 2024-01-23
 */
public interface ProTaskWorkorderMapper
{
    /**
     * 查询任务合并工单
     *
     * @param taskWorkorderId 任务合并工单主键
     * @return 任务合并工单
     */
    public ProTaskWorkorder selectProTaskWorkorderByTaskWorkorderId(Long taskWorkorderId);

    /**
     * 查询任务合并工单列表
     *
     * @param proTaskWorkorder 任务合并工单
     * @return 任务合并工单集合
     */
    public List<ProTaskWorkorder> selectProTaskWorkorderList(ProTaskWorkorder proTaskWorkorder);

    /**
     * 新增任务合并工单
     *
     * @param proTaskWorkorder 任务合并工单
     * @return 结果
     */
    public int insertProTaskWorkorder(ProTaskWorkorder proTaskWorkorder);

    /**
     * 修改任务合并工单
     *
     * @param proTaskWorkorder 任务合并工单
     * @return 结果
     */
    public int updateProTaskWorkorder(ProTaskWorkorder proTaskWorkorder);

    /**
     * 删除任务合并工单
     *
     * @param taskWorkorderId 任务合并工单主键
     * @return 结果
     */
    public int deleteProTaskWorkorderByTaskWorkorderId(Long taskWorkorderId);

    /**
     * 批量删除任务合并工单
     *
     * @param taskWorkorderIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteProTaskWorkorderByTaskWorkorderIds(Long[] taskWorkorderIds);

    /**
     * 查询任务合并工单列表
     *
     * @param query 任务合并工单
     * @return 任务合并工单集合
     */

    @Select(value = "select * from pro_task_workorder ${ew.customSqlSegment}")
    public List<ProTaskWorkorder> selectProTaskWorkorder(@Param("ew") QueryWrapper<ProTaskWorkorder> query);


    @Select("SELECT  wo.workorder_id,\n" +
            "                wo.workorder_code,\n" +
            "                pc.combination_code,\n" +
            "                pa.arrange_code,\n" +
            "                wo.sales_voucher,\n" +
            "                wo.product_code,\n" +
            "                wo.product_name,\n" +
            "                wo.product_spc,\n" +
            "                wo.quantity,\n" +
            "                wo.request_date\n" +
            "from   pro_workorder wo\n" +
            "left join pro_combination pc on wo.workorder_id = pc.workorder_id\n" +
            "left join pro_arrange pa on wo.workorder_id = pa.workorder_id ${ew.customSqlSegment} \n" +
            "ORDER BY wo.create_time desc")
    List<ProTaskWorkorderReportFormListVo> selectReportFormList(@Param("ew") QueryWrapper<ProTaskWorkorderReportFormListVo> query);

    @Select(" select task.task_id,task.process_id,task.quantity, task.task_code from pro_task_workorder ta LEFT JOIN pro_task task on ta.task_id=task.task_id where task.process_id=#{processId} and ta.workorder_id=#{workorderId}")
    ProTask selectProTaskWorkorderReportForm(@Param("processId") Long processId,@Param("workorderId") Long workorderId);

    @Select(value = "select * from pro_task_workorder where task_id=#{taskId} ")
    List<ProTaskWorkorder> selectProTaskWorkorderTaskId(@Param("taskId") Long taskId);

    void deleteByTaskIds(@Param("taskIds")List<Long> taskIds);
}
