package com.ximai.mes.md.service.impl;

import java.util.List;

import com.ximai.common.constant.UserConstants;
import com.ximai.common.utils.data.DateUtils;
import com.ximai.common.utils.SecurityUtils;
import com.ximai.system.strategy.AutoCodeUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.md.mapper.MdVehicleDispatchMapper;
import com.ximai.mes.md.domain.MdVehicleDispatch;
import com.ximai.mes.md.service.IMdVehicleDispatchService;

/**
 * 派车记录Service业务层处理
 *
 * @author generator
 * @date 2024-01-25
 */
@Service
public class MdVehicleDispatchServiceImpl implements IMdVehicleDispatchService
{
    @Autowired
    private MdVehicleDispatchMapper mdVehicleDispatchMapper;
    @Autowired
    private AutoCodeUtil autoCodeUtil;
    /**
     * 查询派车记录
     *
     * @param dispatchId 派车记录主键
     * @return 派车记录
     */
    @Override
    public MdVehicleDispatch selectMdVehicleDispatchByDispatchId(Long dispatchId)
    {
        return mdVehicleDispatchMapper.selectMdVehicleDispatchByDispatchId(dispatchId);
    }

    /**
     * 查询派车记录列表
     *
     * @param mdVehicleDispatch 派车记录
     * @return 派车记录
     */
    @Override
    public List<MdVehicleDispatch> selectMdVehicleDispatchList(MdVehicleDispatch mdVehicleDispatch)
    {
        return mdVehicleDispatchMapper.selectMdVehicleDispatchList(mdVehicleDispatch);
    }

    /**
     * 新增派车记录
     *
     * @param mdVehicleDispatch 派车记录
     * @return 结果
     */
    @Override
    public int insertMdVehicleDispatch(MdVehicleDispatch mdVehicleDispatch)
    {
        mdVehicleDispatch.setCreateTime(DateUtils.getNowDate());
        String code = autoCodeUtil.genSerialCode(UserConstants.VEHICLE_DISPATCH_CODE, null);
        mdVehicleDispatch.setDispatchCode(code);
        mdVehicleDispatch.setStatus(1);
        return mdVehicleDispatchMapper.insertMdVehicleDispatch(mdVehicleDispatch);
    }

    /**
     * 修改派车记录
     *
     * @param mdVehicleDispatch 派车记录
     * @return 结果
     */
    @Override
    public int updateMdVehicleDispatch(MdVehicleDispatch mdVehicleDispatch)
    {
        mdVehicleDispatch.setUpdateTime(DateUtils.getNowDate());
        //确认派送
        if(mdVehicleDispatch.getStatus()==2){
            mdVehicleDispatch.setDispatchBy(SecurityUtils.getUsername());
        }
        return mdVehicleDispatchMapper.updateMdVehicleDispatch(mdVehicleDispatch);
    }

    /**
     * 批量删除派车记录
     *
     * @param dispatchIds 需要删除的派车记录主键
     * @return 结果
     */
    @Override
    public int deleteMdVehicleDispatchByDispatchIds(Long[] dispatchIds)
    {
        return mdVehicleDispatchMapper.deleteMdVehicleDispatchByDispatchIds(dispatchIds);
    }

    /**
     * 删除派车记录信息
     *
     * @param dispatchId 派车记录主键
     * @return 结果
     */
    @Override
    public int deleteMdVehicleDispatchByDispatchId(Long dispatchId)
    {
        return mdVehicleDispatchMapper.deleteMdVehicleDispatchByDispatchId(dispatchId);
    }
}
