package com.ximai.mes.md.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.md.domain.MdSalesPaymentClause;
import com.ximai.mes.md.service.IMdSalesPaymentClauseService;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 销售订单付款条件Controller
 *
 * @author yinjinlu
 * @date 2024-01-22
 */
@RestController
@RequestMapping("/md/payment")
public class MdSalesPaymentClauseController extends BaseController
{
    @Autowired
    private IMdSalesPaymentClauseService mdSalesPaymentClauseService;

    /**
     * 查询销售订单付款条件列表
     */
    @PreAuthorize("@ss.hasPermi('md:payment:list')")
    @GetMapping("/list")
    public TableDataInfo list(MdSalesPaymentClause mdSalesPaymentClause)
    {
        startPage();
        List<MdSalesPaymentClause> list = mdSalesPaymentClauseService.selectMdSalesPaymentClauseList(mdSalesPaymentClause);
        return getDataTable(list);
    }


    /**
     * 获取销售订单付款条件详细信息
     */
    @PreAuthorize("@ss.hasPermi('md:payment:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") String id)
    {
        return AjaxResult.success(mdSalesPaymentClauseService.selectMdSalesPaymentClauseById(id));
    }

    /**
     * 新增销售订单付款条件
     */
    @PreAuthorize("@ss.hasPermi('md:payment:add')")
    @Log(title = "销售订单付款条件", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody MdSalesPaymentClause mdSalesPaymentClause)
    {
        return toAjax(mdSalesPaymentClauseService.insertMdSalesPaymentClause(mdSalesPaymentClause));
    }

    /**
     * 修改销售订单付款条件
     */
    @PreAuthorize("@ss.hasPermi('md:payment:edit')")
    @Log(title = "销售订单付款条件", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody MdSalesPaymentClause mdSalesPaymentClause)
    {
        return toAjax(mdSalesPaymentClauseService.updateMdSalesPaymentClause(mdSalesPaymentClause));
    }

    /**
     * 删除销售订单付款条件
     */
    @PreAuthorize("@ss.hasPermi('md:payment:remove')")
    @Log(title = "销售订单付款条件", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable String[] ids)
    {
        return toAjax(mdSalesPaymentClauseService.deleteMdSalesPaymentClauseByIds(ids));
    }
}
