package com.ximai.mes.md.controller;

import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import io.swagger.annotations.ApiOperation;
import com.ximai.mes.md.domain.MdItemWarehouse;
import com.ximai.mes.md.dto.MdItemWarehouseDto;
import com.ximai.mes.md.dto.MdItemWarehouseQuery;
import com.ximai.mes.md.dto.MdItemWarehouseCreate;
import com.ximai.mes.md.dto.MdItemWarehouseUpdate;
import com.ximai.mes.md.dto.MdItemWarehouseExcelExport;
import com.ximai.mes.md.service.IMdItemWarehouseService;
import com.ximai.common.utils.excel.ExcelWriter;
import cn.hutool.core.bean.BeanUtil;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 物料仓库Controller
 *
 * @author generator
 * @date 2024-10-20
 */
@RestController
@RequestMapping("/itemWarehouse/warehouse")
public class MdItemWarehouseController extends BaseController
{
    @Autowired
    private IMdItemWarehouseService mdItemWarehouseService;

    /**
     * 查询物料仓库列表
     */
    @ApiOperation("查询物料仓库列表")
    @PreAuthorize("@ss.hasPermi('itemWarehouse:warehouse:list')")
    @GetMapping("/list")
    public TableDataInfo<MdItemWarehouseDto> list(MdItemWarehouseQuery mdItemWarehouseQuery) {
        startPage();
        QueryWrapper<MdItemWarehouse> query = new QueryWrapper<>();
        query.eq(mdItemWarehouseQuery.getItemId()!=null, "m.item_id", mdItemWarehouseQuery.getItemId());
        query.eq(StringUtils.isNotEmpty(mdItemWarehouseQuery.getItemCode()), "m.item_code", mdItemWarehouseQuery.getItemCode());
        query.eq(mdItemWarehouseQuery.getWarehouseId()!=null, "m.warehouse_id", mdItemWarehouseQuery.getWarehouseId());
        query.eq(StringUtils.isNotEmpty(mdItemWarehouseQuery.getWarehouseCode()), "m.warehouse_code", mdItemWarehouseQuery.getWarehouseCode());
        query.eq(StringUtils.isNotEmpty(mdItemWarehouseQuery.getLocation()), "m.location", mdItemWarehouseQuery.getLocation());
        query.eq(mdItemWarehouseQuery.getSafetyStock()!=null, "m.safety_stock", mdItemWarehouseQuery.getSafetyStock());
        List<MdItemWarehouseDto> list = mdItemWarehouseService.selectMdItemWarehouseDtoList(query);
        return getDataTable(list);
    }

    /**
     * 导出物料仓库列表
     */
    @ApiOperation("导出物料仓库列表")
    @PreAuthorize("@ss.hasPermi('itemWarehouse:warehouse:export')")
    @Log(title = "物料仓库", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, MdItemWarehouse mdItemWarehouse) throws IOException {
        List<MdItemWarehouseDto> list = mdItemWarehouseService.selectMdItemWarehouseList(mdItemWarehouse);
        List<MdItemWarehouseExcelExport> exportList = BeanUtil.copyToList(list, MdItemWarehouseExcelExport.class);
        ExcelWriter.write(response, MdItemWarehouseExcelExport.class, exportList);
    }

    /**
     * 获取物料仓库详细信息
     */
    @ApiOperation("获取物料仓库详细信息")
    @PreAuthorize("@ss.hasPermi('itemWarehouse:warehouse:query')")
    @GetMapping(value = "/{itemWarehouseId}")
    public AjaxResult<MdItemWarehouseDto> getInfo(@PathVariable("itemWarehouseId") Long itemWarehouseId) {
        return AjaxResult.success(mdItemWarehouseService.selectMdItemWarehouseDtoByItemWarehouseId(itemWarehouseId));
    }

    /**
     * 新增物料仓库
     */
    @ApiOperation("新增物料仓库")
    @PreAuthorize("@ss.hasPermi('itemWarehouse:warehouse:add')")
    @Log(title = "物料仓库", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody MdItemWarehouseCreate mdItemWarehouseCreate) {
        return toAjax(mdItemWarehouseService.insertMdItemWarehouse(mdItemWarehouseCreate));
    }

    /**
     * 修改物料仓库
     */
    @ApiOperation("修改物料仓库")
    @PreAuthorize("@ss.hasPermi('itemWarehouse:warehouse:edit')")
    @Log(title = "物料仓库", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody MdItemWarehouseUpdate mdItemWarehouseUpdate) {
        return toAjax(mdItemWarehouseService.updateMdItemWarehouse(mdItemWarehouseUpdate));
    }

    /**
     * 删除物料仓库
     */
    @ApiOperation("删除物料仓库")
    @PreAuthorize("@ss.hasPermi('itemWarehouse:warehouse:remove')")
    @Log(title = "物料仓库", businessType = BusinessType.DELETE)
	@DeleteMapping("/{itemWarehouseIds}")
    public AjaxResult remove(@PathVariable Long[] itemWarehouseIds) {
        return toAjax(mdItemWarehouseService.deleteMdItemWarehouseByItemWarehouseIds(itemWarehouseIds));
    }
}
