package com.ximai.mes.cal.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.cal.domain.CalPlan;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 排班计划Mapper接口
 *
 * @date 2022-06-06
 */
public interface CalPlanMapper {
    /**
     * 查询排班计划
     *
     * @param planId 排班计划主键
     * @return 排班计划
     */
    CalPlan selectCalPlanByPlanId(Long planId);

    /**
     * 查询排班计划列表
     *
     * @param calPlan 排班计划
     * @return 排班计划集合
     */
    List<CalPlan> selectCalPlanList(CalPlan calPlan);


    /**
     * 新增排班计划
     *
     * @param calPlan 排班计划
     * @return 结果
     */
    int insertCalPlan(CalPlan calPlan);

    /**
     * 修改排班计划
     *
     * @param calPlan 排班计划
     * @return 结果
     */
    int updateCalPlan(CalPlan calPlan);

    /**
     * 删除排班计划
     *
     * @param planId 排班计划主键
     * @return 结果
     */
    int deleteCalPlanByPlanId(Long planId);

    /**
     * 批量删除排班计划
     *
     * @param planIds 需要删除的数据主键集合
     * @return 结果
     */
    int deleteCalPlanByPlanIds(Long[] planIds);

    @Select("select * from cal_plan ${ew.customSqlSegment}")
    List<CalPlan> selectListByQw(@Param("ew") QueryWrapper<CalPlan> query);
}
