package com.ximai.common.constant;

import io.jsonwebtoken.Claims;

/**
 * 通用常量信息
 */
public class Constants {
    /**
     * UTF-8 字符集
     */
    public static final String UTF8 = "UTF-8";

    /**
     * GBK 字符集
     */
    public static final String GBK = "GBK";

    /**
     * http请求
     */
    public static final String HTTP = "http://";

    /**
     * https请求
     */
    public static final String HTTPS = "https://";

    /**
     * 通用成功标识
     */
    public static final String SUCCESS = "0";

    /**
     * 通用失败标识
     */
    public static final String FAIL = "1";

    /**
     * 登录成功
     */
    public static final String LOGIN_SUCCESS = "Success";

    /**
     * 注销
     */
    public static final String LOGOUT = "Logout";

    /**
     * 注册
     */
    public static final String REGISTER = "Register";

    /**
     * 登录失败
     */
    public static final String LOGIN_FAIL = "Error";

    /**
     * 验证码 redis key
     */
    public static final String CAPTCHA_CODE_KEY = "captcha_codes:";

    /**
     * 登录用户 redis key
     */
    public static final String LOGIN_TOKEN_KEY = "login_tokens:";

    /**
     * 防重提交 redis key
     */
    public static final String REPEAT_SUBMIT_KEY = "repeat_submit:";

    /**
     * 限流 redis key
     */
    public static final String RATE_LIMIT_KEY = "rate_limit:";

    /**
     * 验证码有效期（分钟）
     */
    public static final Integer CAPTCHA_EXPIRATION = 2;

    /**
     * 令牌
     */
    public static final String TOKEN = "token";

    /**
     * 令牌前缀
     */
    public static final String TOKEN_PREFIX = "Bearer ";

    /**
     * 令牌前缀
     */
    public static final String LOGIN_USER_KEY = "login_user_key";

    /**
     * 用户ID
     */
    public static final String JWT_USERID = "userid";

    /**
     * 用户多语言
     */
    public static final String JWT_LOCAL = "local";

    /**
     * 用户名称
     */
    public static final String JWT_USERNAME = Claims.SUBJECT;

    /**
     * 用户头像
     */
    public static final String JWT_AVATAR = "avatar";

    /**
     * 创建时间
     */
    public static final String JWT_CREATED = "created";

    /**
     * 用户权限
     */
    public static final String JWT_AUTHORITIES = "authorities";

    /**
     * 参数管理 cache key
     */
    public static final String SYS_CONFIG_KEY = "sys_config:";

    /**
     * 字典管理 cache key
     */
    public static final String SYS_DICT_KEY = "sys_dict:";

    /**
     * 资源映射路径 前缀
     */
    public static final String RESOURCE_PREFIX = "/profile";

    /**
     * RMI 远程方法调用
     */
    public static final String LOOKUP_RMI = "rmi:";

    /**
     * LDAP 远程方法调用
     */
    public static final String LOOKUP_LDAP = "ldap:";

    /**
     * LDAPS 远程方法调用
     */
    public static final String LOOKUP_LDAPS = "ldaps:";

    /**
     * 定时任务白名单配置（仅允许访问的包名，如其他需要可以自行添加）
     */
    public static final String[] JOB_WHITELIST_STR = {"com.ruoyi"};

    /**
     * 定时任务违规的字符
     */
    public static final String[] JOB_ERROR_STR = {"java.net.URL", "javax.naming.InitialContext", "org.yaml.snakeyaml",
            "org.springframework", "org.apache", "com.ruoyi.common.utils.file"};


    public static final String METHOD_INSERT_TYPE = "insert";
    public static final String METHOD_UPDATE_TYPE = "update";
    public static final String METHOD_DELETE_TYPE = "delete";

    public static class DateConstant {

        public static String YYYY = "yyyy";

        public static String YYYY_MM = "yyyy-MM";

        public static String YYYY_MM_DD = "yyyy-MM-dd";

        public static String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";

        public static String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";

        /**
         * 星期日;
         */
        public static final String SUNDAY = "星期日";

        /**
         * 星期一;
         */
        public static final String MONDAY = "星期一";

        /**
         * 星期二;
         */
        public static final String TUESDAY = "星期二";

        /**
         * 星期三;
         */
        public static final String WEDNESDAY = "星期三";

        /**
         * 星期四;
         */
        public static final String THURSDAY = "星期四";

        /**
         * 星期五;
         */
        public static final String FRIDAY = "星期五";

        /**
         * 星期六;
         */
        public static final String SATURDAY = "星期六";

        /**
         * 显示年月日时分秒，例如 2015-08-11 09:51:53.
         */
        public static final String DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
        /**
         * 显示年月日时分，例如 2015-08-11 09:51.
         */
        public static final String NO_SECOND_DATETIME_PATTERN = "yyyy-MM-dd HH:mm";
        /**
         * 仅显示年月日，例如 2015-08-11.
         */
        public static final String DATE_PATTERN = "yyyy-MM-dd";
        /**
         * 仅显示时分秒，例如 09:51:53.
         */
        public static final String TIME_PATTERN = "HH:mm:ss";
        /**
         * 显示年月日时分秒(由/分割)，例如 2015/08/11 09:51:53.
         */
        public static final String DATETIME_PATTERN_WITH_SLASH = "yyyy/MM/dd HH:mm:ss";
        /**
         * 显示年月日(由/分割)，例如 2015/08/11.
         */
        public static final String DATE_PATTERN_WITH_SLASH = "yyyy/MM/dd";
        /**
         * 仅显示年(无符号)，例如 2015.
         */
        public static final String YEAR_PATTERN = "yyyy";
        /**
         * 仅显示年月，例如 2015-08.
         */
        public static final String MONTH_PATTERN = "yyyy-MM";

    }
}
