package com.ximai.mes.qc.dto;

import com.ximai.mes.constant.TaskStatusEnum;

/**
 * 车间异常单类型
 *
 * @author generator
 * @date 2024-11-6
 */
public enum QcAbnormalTypeEnum {


    /**
     * 设备异常
     */
    DEVI("DEVI"),

    /**
     * 生产异常
     */
    PROD("PROD"),
    /**
     * 不合格异常
     */
    UNQUALIFIED_REASON("UNQUALIFIED_REASON");

    private final String type;

    QcAbnormalTypeEnum(String type) {
        this.type = type;
    }

    public String getType() {
        return type;
    }

    public static QcAbnormalTypeEnum get(String type) {
        for (QcAbnormalTypeEnum temp : QcAbnormalTypeEnum.values()) {
            if (temp.getType().equals(type)) {
                return temp;
            }
        }
        return null;
    }


}
