package com.ximai.mes.qc.dto;

import com.ximai.mes.constant.TaskStatusEnum;

/**
 * 车间异常单状态对象 QcAbnormalReportStatusEnum
 *
 * @author generator
 * @date 2024-02-20
 */
public enum QcAbnormalReportStatusEnum {


    /**
     * 已提交
     */
    SUBMIT("SUBMIT"),

    /**
     * 关闭
     */
    CLOSE("CLOSE"),
    /**
     * 未提交
     */
    NOT("NOT"),
    /**
     * 完成
     */
    FINISH("FINISH");

    /**
     * Lock type
     */
    private final String status;

    QcAbnormalReportStatusEnum(String status) {
        this.status = status;
    }

    public String getStatus() {
        return status;
    }

    public static QcAbnormalReportStatusEnum get(String status) {
        for (QcAbnormalReportStatusEnum temp : QcAbnormalReportStatusEnum.values()) {
            if (temp.getStatus().equals(status)) {
                return temp;
            }
        }
        return null;
    }


}
