package com.ximai.mes.pro.service.proWorkOrder;

import java.util.List;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderProcessQcindex;

/**
 * 工单工序工装Service接口
 *
 * @author zht
 * @date 2024-01-28
 */
public interface IProWorkOrderProcessQcindexService
{
    /**
     * 查询工单工序工装
     *
     * @param workorderProcessQcindex 工单工序工装主键
     * @return 工单工序工装
     */
    public ProWorkOrderProcessQcindex selectProWorkOrderProcessQcindexByWorkorderProcessQcindex(Long workorderProcessQcindex);

    /**
     * 查询工单工序工装列表
     *
     * @param proWorkOrderProcessQcindex 工单工序工装
     * @return 工单工序工装集合
     */
    public List<ProWorkOrderProcessQcindex> selectProWorkOrderProcessQcindexList(ProWorkOrderProcessQcindex proWorkOrderProcessQcindex);

    /**
     * 新增工单工序工装
     *
     * @param proWorkOrderProcessQcindex 工单工序工装
     * @return 结果
     */
    public int insertProWorkOrderProcessQcindex(ProWorkOrderProcessQcindex proWorkOrderProcessQcindex);

    /**
     * 修改工单工序工装
     *
     * @param proWorkOrderProcessQcindex 工单工序工装
     * @return 结果
     */
    public int updateProWorkOrderProcessQcindex(ProWorkOrderProcessQcindex proWorkOrderProcessQcindex);

    /**
     * 批量删除工单工序工装
     *
     * @param workorderProcessQcindexs 需要删除的工单工序工装主键集合
     * @return 结果
     */
    public int deleteProWorkOrderProcessQcindexByWorkorderProcessQcindexs(Long[] workorderProcessQcindexs);

    /**
     * 删除工单工序工装信息
     *
     * @param workorderProcessQcindex 工单工序工装主键
     * @return 结果
     */
    public int deleteProWorkOrderProcessQcindexByWorkorderProcessQcindex(Long workorderProcessQcindex);
}
