package com.ximai.mes.pro.service.impl;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.common.utils.data.DateUtils;
import com.ximai.common.utils.SecurityUtils;
import com.ximai.common.utils.data.ExceptionUtil;
import com.ximai.common.utils.data.StringUtils;
import com.ximai.mes.md.domain.MdWorkstation;
import com.ximai.mes.md.mapper.MdWorkstationMapper;
import com.ximai.mes.md.mapper.MdWorkunitMapper;
import com.ximai.mes.pro.domain.task.ProTaskWorkunit;
import com.ximai.mes.pro.domain.vo.ProAllocationItemList;
import com.ximai.mes.pro.domain.vo.ProWorkstationMaterialVo;
import com.ximai.mes.pro.mapper.task.ProTaskMapper;
import com.ximai.mes.pro.mapper.task.ProTaskWorkunitMapper;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.pro.mapper.ProWorkstationMaterialMapper;
import com.ximai.mes.pro.domain.ProWorkstationMaterial;
import com.ximai.mes.pro.service.IProWorkstationMaterialService;

/**
 * 工作中心发料申请Service业务层处理
 *
 * @author generator
 * @date 2024-07-26
 */
@Service
public class ProWorkstationMaterialServiceImpl implements IProWorkstationMaterialService
{
    @Autowired
    private ProWorkstationMaterialMapper proWorkstationMaterialMapper;

    @Autowired
    private ProTaskMapper proTaskMapper;

    @Autowired
    private ProTaskWorkunitMapper proTaskWorkunitMapper;

    @Autowired
    private MdWorkstationMapper mdWorkstationMapper;
    @Autowired
    private MdWorkunitMapper mdWorkunitMapper;


    /**
     * 查询工作中心发料申请
     *
     * @param workstationMaterialId 工作中心发料申请主键
     * @return 工作中心发料申请
     */
    @Override
    public ProWorkstationMaterialVo selectProWorkstationMaterialByWorkstationMaterialId(Long workstationMaterialId)
    {
        return proWorkstationMaterialMapper.selectProWorkstationMaterialByWorkstationMaterialId(workstationMaterialId);
    }

    /**
     * 查询工作中心发料申请列表
     *
     * @param proWorkstationMaterial 工作中心发料申请
     * @return 工作中心发料申请
     */
    @Override
    public List<ProWorkstationMaterialVo> selectProWorkstationMaterialList(ProWorkstationMaterialVo proWorkstationMaterial)
    {
        return proWorkstationMaterialMapper.selectProWorkstationMaterialList(proWorkstationMaterial);
    }

    /**
     * 新增工作中心发料申请
     *
     * @param proWorkstationMaterial 工作中心发料申请
     * @return 结果
     */
    @Override
    public int insertProWorkstationMaterial(ProWorkstationMaterial proWorkstationMaterial) {
        List<ProAllocationItemList> itemList = proWorkstationMaterial.getItemList();
        List<ProTaskWorkunit> proTaskWorkunits = proTaskWorkunitMapper.selectProTaskWorkunitByTaskIds(proWorkstationMaterial.getTaskId());
        ProTaskWorkunit proTaskWorkunit = proTaskWorkunits.get(0);
        if (CollUtil.isNotEmpty(itemList)) {
            for (ProAllocationItemList list : itemList) {
                ProWorkstationMaterial proWorkstationMaterials=proWorkstationMaterialMapper.selectProWorkstationMaterialItemApplyNo(list.getItemId(),proWorkstationMaterial.getApplyNo());
                if(Objects.nonNull(proWorkstationMaterials)){
                    BigDecimal add = list.getApplyNum().add(proWorkstationMaterials.getApplyNum());
                    proWorkstationMaterials.setApplyNum(add);
                    proWorkstationMaterialMapper.updateProWorkstationMaterial(proWorkstationMaterials);
                }else{
                    ProWorkstationMaterial proWorkstationMaterial1 = proWorkstationMaterial.getProWorkstationMaterial(proWorkstationMaterial);
                    BeanUtils.copyProperties(list, proWorkstationMaterial1);
                    proWorkstationMaterial1.setTaskWorkunitId(proTaskWorkunit.getTaskWorkunitId());
                    MdWorkstation mdWorkstation = mdWorkstationMapper.selectMdWorkstationByWorkstationCodes(proWorkstationMaterial.getWorkstationCode());
                    proWorkstationMaterial1.setWorkstationName(mdWorkstation.getWorkstationName());
                    proWorkstationMaterial1.setWorkstationId(mdWorkstation.getWorkstationId());
                    proWorkstationMaterial1.setWorkstationCode(proWorkstationMaterial.getWorkstationCode());
                    proWorkstationMaterial1.setApplyType(1L);
                    proWorkstationMaterial1.setWindCase("N");
                    proWorkstationMaterial1.setWorkstationId(mdWorkstation.getWorkstationId());
                    proWorkstationMaterial1.setCreateBy(SecurityUtils.getUsername());
                    proWorkstationMaterial1.setCreateTime(DateUtils.getNowDate());
                    proWorkstationMaterialMapper.insertProWorkstationMaterial(proWorkstationMaterial1);
                }

            }
        }

        return 1;
    }

    /**
     * 修改工作中心发料申请
     *
     * @param proWorkstationMaterial 工作中心发料申请
     * @return 结果
     */
    @Override
    public int updateProWorkstationMaterial(ProWorkstationMaterial proWorkstationMaterial)
    {
        proWorkstationMaterial.setUpdateBy(SecurityUtils.getUsername());
        proWorkstationMaterial.setUpdateTime(DateUtils.getNowDate());
        return proWorkstationMaterialMapper.updateProWorkstationMaterial(proWorkstationMaterial);
    }

    /**
     * 批量删除工作中心发料申请
     *
     * @param workstationMaterialIds 需要删除的工作中心发料申请主键
     * @return 结果
     */
    @Override
    public int deleteProWorkstationMaterialByWorkstationMaterialIds(Long[] workstationMaterialIds)
    {
        return proWorkstationMaterialMapper.deleteProWorkstationMaterialByWorkstationMaterialIds(workstationMaterialIds);
    }

    /**
     * 删除工作中心发料申请信息
     *
     * @param workstationMaterialId 工作中心发料申请主键
     * @return 结果
     */
    @Override
    public int deleteProWorkstationMaterialByWorkstationMaterialId(Long workstationMaterialId)
    {
        return proWorkstationMaterialMapper.deleteProWorkstationMaterialByWorkstationMaterialId(workstationMaterialId);
    }

    @Override
    public List<ProWorkstationMaterialVo> selectProWorkstationMaterialLists(QueryWrapper<ProWorkstationMaterial> query) {

        return proWorkstationMaterialMapper.selectProWorkstationMaterialLists(query);
    }

    @Override
    public void updateWorkstationUpadteNum(List<ProWorkstationMaterial> proWorkstationMaterials) {
        for (ProWorkstationMaterial pro : proWorkstationMaterials) {
            ProWorkstationMaterialVo proWorkstationMaterial = new ProWorkstationMaterialVo();
            proWorkstationMaterial.setApplyNo(pro.getApplyNo());
            List<ProWorkstationMaterialVo> workstationMaterial = proWorkstationMaterialMapper.selectProWorkstationMaterialList(proWorkstationMaterial);
            for (ProWorkstationMaterialVo MaterialVo : workstationMaterial) {
                if(pro.getSapItemCode().equals(MaterialVo.getSapItemCode())){
                    if(StringUtils.isEmpty(MaterialVo.getGrantNum())){
                        ProWorkstationMaterial proWorkstationMaterial1 = new ProWorkstationMaterial();
                        BeanUtils.copyProperties(MaterialVo,proWorkstationMaterial1);
                        proWorkstationMaterial1.setGrantNum(pro.getGrantNum());
                        proWorkstationMaterial1.setWindCase(pro.getWindCase());
                         proWorkstationMaterialMapper.updateProWorkstationMaterial(proWorkstationMaterial1);
                    }else{
                        BigDecimal add = MaterialVo.getGrantNum().add(pro.getGrantNum());
                        ProWorkstationMaterial proWorkstationMaterial1 = new ProWorkstationMaterial();
                        BeanUtils.copyProperties(MaterialVo,proWorkstationMaterial1);
                        proWorkstationMaterial1.setGrantNum(add);
                        proWorkstationMaterial1.setWindCase(pro.getWindCase());
                        proWorkstationMaterialMapper.updateProWorkstationMaterial(proWorkstationMaterial1);

                    }
                }
            }
        }
    }
}
