package com.ximai.mes.pro.service.impl;

import java.util.List;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.common.utils.data.DateUtils;
import com.ximai.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import cn.hutool.core.bean.BeanUtil;
import com.ximai.mes.pro.mapper.ProStorageDetailRecordMapper;
import com.ximai.mes.pro.domain.ProStorageDetailRecord;
import com.ximai.mes.pro.dto.ProStorageDetailRecordCreate;
import com.ximai.mes.pro.dto.ProStorageDetailRecordUpdate;
import com.ximai.mes.pro.dto.ProStorageDetailRecordDto;
import com.ximai.mes.pro.service.IProStorageDetailRecordService;

/**
 * 入库明细记录Service业务层处理
 *
 * @author generator
 * @date 2025-10-12
 */
@Service
public class ProStorageDetailRecordServiceImpl implements IProStorageDetailRecordService
{
    @Autowired
    private ProStorageDetailRecordMapper proStorageDetailRecordMapper;

    /**
     * 查询入库明细记录
     *
     * @param recordId 入库明细记录主键
     * @return 入库明细记录
     */
    @Override
    public ProStorageDetailRecordDto selectProStorageDetailRecordDtoByRecordId(Long recordId) {
        return proStorageDetailRecordMapper.selectProStorageDetailRecordByRecordId(recordId);
    }

    /**
     * 查询入库明细记录
     *
     * @param recordId 入库明细记录主键
     * @return 入库明细记录
     */
    @Override
    public ProStorageDetailRecord selectProStorageDetailRecordByRecordId(Long recordId) {
        return proStorageDetailRecordMapper.selectById(recordId);
    }

    /**
     * 查询入库明细记录列表
     *
     * @param proStorageDetailRecord 入库明细记录
     * @return 入库明细记录
     */
    @Override
    public List<ProStorageDetailRecordDto> selectProStorageDetailRecordList(ProStorageDetailRecord proStorageDetailRecord) {
        return proStorageDetailRecordMapper.selectProStorageDetailRecordList(proStorageDetailRecord);
    }

    /**
     * 查询入库明细记录列表
     *
     * @param proStorageDetailRecordQuery 入库明细记录
     * @return 入库明细记录
     */
    @Override
    public List<ProStorageDetailRecord> selectProStorageDetailRecordList(QueryWrapper<ProStorageDetailRecord> proStorageDetailRecordQuery) {
        return proStorageDetailRecordMapper.selectList(proStorageDetailRecordQuery);
    }

    /**
     * 根据箱码查询入库明细记录列表
     *
     * @param boxCode 箱码
     * @return 入库明细记录
     */
    @Override
    public List<ProStorageDetailRecordDto> selectProStorageDetailRecordByBoxCode(String boxCode) {
        return proStorageDetailRecordMapper.selectProStorageDetailRecordByBoxCode(boxCode);
    }

    /**
     * 新增入库明细记录
     *
     * @param proStorageDetailRecordCreate 入库明细记录
     * @return 结果
     */
    @Override
    public int insertProStorageDetailRecord(ProStorageDetailRecordCreate proStorageDetailRecordCreate) {
        ProStorageDetailRecord proStorageDetailRecord = new ProStorageDetailRecord();
        BeanUtil.copyProperties(proStorageDetailRecordCreate, proStorageDetailRecord);
        proStorageDetailRecord.setCreateTime(DateUtils.getNowDate());
        return proStorageDetailRecordMapper.insertProStorageDetailRecord(proStorageDetailRecord);
    }

    /**
     * 修改入库明细记录
     *
     * @param proStorageDetailRecordUpdate 入库明细记录
     * @return 结果
     */
    @Override
    public int updateProStorageDetailRecord(ProStorageDetailRecordUpdate proStorageDetailRecordUpdate) {
        ProStorageDetailRecord proStorageDetailRecord = new ProStorageDetailRecord();
        BeanUtil.copyProperties(proStorageDetailRecordUpdate, proStorageDetailRecord);
        proStorageDetailRecord.setUpdateBy(SecurityUtils.getUsername());
        proStorageDetailRecord.setUpdateTime(DateUtils.getNowDate());
        return proStorageDetailRecordMapper.updateProStorageDetailRecord(proStorageDetailRecord);
    }

    /**
     * 批量删除入库明细记录
     *
     * @param recordIds 需要删除的入库明细记录主键
     * @return 结果
     */
    @Override
    public int deleteProStorageDetailRecordByRecordIds(Long[] recordIds) {
        return proStorageDetailRecordMapper.deleteProStorageDetailRecordByRecordIds(recordIds);
    }

    /**
     * 删除入库明细记录信息
     *
     * @param recordId 入库明细记录主键
     * @return 结果
     */
    @Override
    public int deleteProStorageDetailRecordByRecordId(Long recordId) {
        return proStorageDetailRecordMapper.deleteProStorageDetailRecordByRecordId(recordId);
    }
}

