package com.ximai.mes.pro.schedule;

import com.ximai.mes.pro.domain.task.WorkorderScheduleParams;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 排产数据源
 */
public interface AlgorithmDataSource {

    /**
     * 获取资源数据
     * @param schedulingStartedDate 排产开始日期
     * @param orderIds 工单ID
     * @return
     */
    public List<Resource> getResource(LocalDateTime schedulingStartedDate, List<WorkorderScheduleParams> workorderScheduleParams);

    /**
     * 获取工单工序作务数据
     * @param schedulingStartedDate 排产开始日期
     * @param orderIds 工单ID
     * @param resources 资源ID
     * @return
     */
    public List<Job> getJob(LocalDateTime schedulingStartedDate, List<WorkorderScheduleParams> workorderScheduleParams, List<Resource> resources);

    /**
     * 获取日历数据
     * @param schedulingStartedDate 排产开始日期
     * @param orderIds
     * @param resources 资源ID
     * @return
     */
    public List<Calendar> getCalendar(LocalDateTime schedulingStartedDate, List<WorkorderScheduleParams> workorderScheduleParams, List<Resource> resources);


}
