package com.ximai.mes.pro.domain.task;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 工序任务外协关系对象 pro_task_assistprocess
 *
 * @author generator
 * @date 2024-03-29
 */

@Data
@NoArgsConstructor
@AllArgsConstructor
public class ProTaskAssistProcess extends BaseEntity {
    private static final long serialVersionUID = 1L;


    public ProTaskAssistProcess(Long taskWorkunitId) {
        this.taskWorkunitId = taskWorkunitId;
    }

    @TableField(exist = false)
    private String actionType;

    @TableField(exist = false)
    private Integer allowProduce;


    @TableField(exist = false)
    private String processIndex;
    /**
     * 主键id
     */
    @TableId
    private Long id;

    /**
     * 外协记录编码(调用放传递)
     */
    @Excel(name = "外协记录编码(调用放传递)")
    private String assistProcessCode;
    private String assistProcessItemCode;
    private String idx;
    private String unit;
    /**
     * 工站id
     */
    @Excel(name = "工站id")
    private Long workstationId;

    /**
     * 工作单元名称
     */
    @Excel(name = "工作单元名称")
    private String workunitName;

    /**
     * 工作单元id
     */
    @Excel(name = "工作单元id")
    private Long workunitId;

    /**
     * 工作单元id
     */
    @Excel(name = "工作单元id")
    private Long taskWorkunitId;

    /**
     * 工序id
     */
    @Excel(name = "工序id")
    private Long processId;

    private Long workorderProcessId;

    /**
     * 工序任务id
     */
    @Excel(name = "工序任务id")
    private Long taskId;

    @Excel(name = "工序任务编码")
    private String taskCode;

    /**
     * 工单id
     */
    @Excel(name = "工单id")
    private Long workorderId;


    private String supplierName;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date scheduleEndDate;

    /**
     * 交回时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "缴回时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date returnTime;

    /**
     * 外协数量
     */
    @Excel(name = "外协数量")
    private Long quantity;


    @TableField(exist = false)
    @Excel(name = "外协数量")
    private Long quantityFeedback;

    @TableField(exist = false)
    private String processName;
    private String processCode;


    @TableField(exist = false)
    private String feedbackType;

    private int closeType = 0;


    private int status;


    private int deleteState;


    private String workorderCode;

    @TableField(exist = false)
    private String childWorkorderCode;


}
