package com.ximai.mes.pro.domain.productionSolution;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 生产版本规格书对象 pro_production_solution_specification_sheet
 *
 * @author zht
 * @date 2024-03-13
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ProProductionSolutionSpecificationSheet extends BaseEntity {

    private static final long serialVersionUID = 2256887790451188529L;
    /**
     * 规格书ID
     */
    @TableId
    private Long specificationSheetId;

    /**
     * 生产版本ID
     */
    @Excel(name = "生产版本ID")
    private Long productionSolutionId;

    /**
     * 规格书类型
     */
    @Excel(name = "规格书类型")
    private String specificationSheetType;
    @TableField(exist = false)
    private String specificationSheetTypeStr;

    /**
     * 品牌
     */
    @Excel(name = "品牌")
    private String brandName;

    /**
     * 英文名称
     */
    @Excel(name = "英文名称")
    private String enName;

    /**
     * 采购单位
     */
    @Excel(name = "采购单位")
    private String purchaseUnit;

    /**
     * 换算值
     */
    @Excel(name = "换算值")
    private String conversionValue;

    /**
     * 单层厚(丝)
     */
    @Excel(name = "单层厚(丝)")
    private BigDecimal singleLayerThick;

    /**
     * 单重(KG)
     */
    @Excel(name = "单重(KG)")
    private BigDecimal singleWeight;

    /**
     * 层数
     */
    @Excel(name = "层数")
    private BigDecimal layerNum;

    /**
     * 长度cm
     */
    @Excel(name = "长度cm")
    private BigDecimal length;

    /**
     * 高度cm
     */
    @Excel(name = "高度cm")
    private BigDecimal height;

    /**
     * 宽度cm
     */
    @Excel(name = "宽度cm")
    private BigDecimal width;

    /**
     * 印张长度
     */
    @Excel(name = "印张长度")
    private BigDecimal printingPaperlenth;

    /**
     * 印张宽度
     */
    @Excel(name = "印张宽度")
    private BigDecimal printPaperwidth;

    /**
     * 派工倍数
     */
    @Excel(name = "派工倍数")
    private BigDecimal sendworkMultiple;

    /**
     * 印刷正面颜色
     */
    @Excel(name = "印刷正面颜色")
    private String frontColorName;

    /**
     * 印刷背面颜色
     */
    @Excel(name = "印刷背面颜色")
    private String oppositeColorName;

    /**
     * 仓库
     */
    @Excel(name = "仓库")
    private String storePlace;

    /**
     * 是否附样品
     */
    @Excel(name = "是否附样品")
    private String isAddSimple;

    /**
     * 是否唯一码产品
     */
    @Excel(name = "是否唯一码产品")
    private String isUniqueCode;

    /**
     * 是否不考虑型体配色
     */
    @Excel(name = "是否不考虑型体配色")
    private String isConsiderColor;

    /**
     * 配方
     */
    @Excel(name = "配方")
    private String formula;

    /**
     * 产品材质
     */
    @Excel(name = "产品材质")
    private String productMaterial;

    /**
     * 分配方式
     */
    @Excel(name = "分配方式")
    private String modality;

    /**
     * 表面处理
     */
    @Excel(name = "表面处理")
    private String surfaceTreatment;

    /**
     * 测试标准
     */
    @Excel(name = "测试标准")
    private String testStandard;

    /**
     * 网版目数
     */
    @Excel(name = "网版目数")
    private Long screenItem;

    /**
     * 啤版目数
     */
    @Excel(name = "啤版目数")
    private Long pibanItem;

    /**
     * 模切版目数
     */
    @Excel(name = "模切版目数")
    private Long diecuttingItem;

    /**
     * 标准色号
     */
    @Excel(name = "标准色号")
    private String standardColor;

    /**
     * 模数
     */
    @Excel(name = "模数")
    private Long module;

    /**
     * 列
     */
    @Excel(name = "列")
    private Long colNum;

    /**
     * 搭板数
     */
    @Excel(name = "搭板数")
    private BigDecimal buttstrapNum;

    /**
     * 列双刀位
     */
    @Excel(name = "列双刀位")
    private BigDecimal coldoubleCutspacing;

    /**
     * 行双刀位
     */
    @Excel(name = "行双刀位")
    private BigDecimal rowdoubleCutspacing;

    /**
     * 成品克重g
     */
    @Excel(name = "成品克重g")
    private BigDecimal weight;

    /**
     * 是否异型
     */
    @Excel(name = "是否异型")
    private String isAllotype;

    /**
     * 是否直角
     */
    @Excel(name = "是否直角 ")
    private String isRightAngle;

    /**
     * 角度(mm)
     */
    @Excel(name = "角度(mm)")
    private BigDecimal angle;

    /**
     * 孔径(mm)
     */
    @Excel(name = "孔径(mm)")
    private BigDecimal aperture;

    /**
     * 厚度mm
     */
    @Excel(name = "厚度mm")
    private BigDecimal thick;

    /**
     * 是否防霉
     */
    @Excel(name = "是否防霉")
    private String isMould;

    /**
     * 是否写码
     */
    @Excel(name = "是否写码")
    private String isCoding;

    /**
     * 体系认证
     */
    @Excel(name = "体系认证")
    private String certification;

    /**
     * 样品形状
     */
    @Excel(name = "样品形状")
    private String shape;


    @TableField(exist = false)
    private String shapeStr;
    /**
     * 样品形状大小
     */
    @Excel(name = "样品形状大小")
    private BigDecimal shapeSize;

    /**
     * 正面照片
     */
    @Excel(name = "正面照片")
    private String frontImg;

    /**
     * 反面照片
     */
    @Excel(name = "反面照片")
    private String backImg;

    /**
     * 吹膜宽度
     */
    @Excel(name = "吹膜宽度")
    private BigDecimal blownFilmWidth;

    /**
     * 吹膜厚度
     */
    @Excel(name = "吹膜厚度")
    private BigDecimal blownFilmThickness;

    /**
     * 印刷宽度
     */
    @Excel(name = "印刷宽度")
    private BigDecimal printingWidth;

    /**
     * Inlay
     */
    @Excel(name = "Inlay")
    private String inlay;

    /**
     * 单位
     */
    @Excel(name = "单位")
    private String unitOfMeasure;

    /**
     * 客户确认人
     */
    @Excel(name = "客户确认人")
    private String customerConfirmedBy;
    private String customerConfirmedByStr;

    /**
     * 客户确认日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "客户确认日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date customerConfirmedDate;

    /**
     * 研发核准人
     */
    @Excel(name = "研发核准人")
    private String rdApprovedBy;
    private String rdApprovedByStr;

    /**
     * 研发审核人
     */
    @Excel(name = "研发审核人")
    private String rdReviewedBy;
    private String rdReviewedByStr;

    /**
     * 研发制定人
     */
    @Excel(name = "研发制定人")
    private String rdPreparedBy;
    private String rdPreparedByStr;

    /**
     * 排版行数
     */
    @Excel(name = "排版行数")
    private Long rowNum;

    /**
     * 是否创建新规格书
     */
    @Excel(name = "是否创建新规格书")
    private String isCreateSpec;

    /**
     * 是否要鞋图
     */
    @Excel(name = "是否要鞋图")
    private String isNeedShoeImg;

    /**
     * 是否圆角
     */
    @Excel(name = "是否圆角")
    private String isFillet;

    /** 凹印_胶版油槽数 */
    @Excel(name = "凹印_胶版油槽数")
    private BigDecimal dieSunkOffsetOilTankNum;

    /** 印刷方式 */
    @Excel(name = "印刷方式")
    private String printingMethod;

}
