package com.ximai.mes.pro.domain.proWorkOrder;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import com.ximai.mes.pro.domain.productionSolution.ProProductionSolutionProcess;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

/**
 * 生产工单工序对象 pro_work_order_process
 *
 * @author yinjinlu
 * @date 2024-01-23
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ProWorkOrderProcess extends BaseEntity {
    private static final long serialVersionUID = 1L;

    public ProWorkOrderProcess(Long workorderId, String processIndex) {
        this.workorderId = workorderId;
        this.processPef = processIndex;
    }

    /**
     * ID
     */
    @TableId
    private Long workorderProcessId;

    /**
     * 生产工单ID
     */
    @Excel(name = "生产工单ID")
    @ApiModelProperty("生产工单ID")
    private Long workorderId;

    private String workorderCode;

    /**
     * 工序id
     */
    @Excel(name = "工序id")
    private Long processId;

    /**
     * 工作中心
     */
    @Excel(name = "工作中心")
    private Long workstationId;


    /**
     * 标准工时
     */
    @Excel(name = "标准工时")
    private BigDecimal stdWorkingTime;

    /**
     * 关键工序
     */
    @Excel(name = "关键工序")
    private String keyFlag;

    /**
     * 是否检验
     */
    @Excel(name = "是否检验")
    private String isCheck;

    /**
     * 序号
     */
    @Excel(name = "序号")
    private String processRef;

    /**
     * 变更编号
     */
    @Excel(name = "变更编号")
    private String enCode;


    /**
     * 工时单位
     */
    private String stdWorkingTimeUom;

    /**
     * 加工方式
     */
    @Excel(name = "加工方式")
    private String controlCode;

    /**
     * 标准文本码
     */
    @Excel(name = "标准文本码")
    private String x;

    /**
     * 工序名称
     */
    @Excel(name = "工序名称")
    private String processName;

    /**
     * 单价
     */
    private BigDecimal unitPrice;


    /**
     * 工序总数量
     */
    @Excel(name = "工序总数量")
    private BigDecimal quantity;

    /**
     * 换型时间
     */
    @Excel(name = "换型时间")
    private BigDecimal lineBreakTime;

    @ApiModelProperty("序号")
    private String idx;

    @ApiModelProperty("是否外协")
    private String outsourced;

    @TableField(exist = false)
    @ApiModelProperty("工作中心名称")
    private String workstationName;


    @TableField(exist = false)
    @ApiModelProperty("工作中心编码")
    private String workstationCode;

    @TableField(exist = false)
    private String arrangeCode;

    @TableField(exist = false)
    private String processPef;


    @TableField(exist = false)
    private Long productId;

    @TableField(exist = false)
    private String productName;

    @TableField(exist = false)
    private int isExistTool;

    public void init(ProProductionSolutionProcess solutionProcess){
        BeanUtil.copyProperties(solutionProcess, this);
    }
}

