package com.ximai.mes.pro.domain;

import java.math.BigDecimal;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;

/**
 * 生产物料扣减对象 pro_material_usage_record
 *
 * @author mengcheng
 * @date 2024-01-21
 */
public class ProMaterialUsageRecord extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 记录ID */
    private Long recordId;

    /** 任务编号 */
    @Excel(name = "任务编号")
    private Long taskId;

    /** 物料批号 */
    @Excel(name = "物料批号")
    private String materialBatchNumber;

    /** 数量 */
    @Excel(name = "数量")
    private BigDecimal quantity;

    /** 操作ID */
    @Excel(name = "操作ID")
    private Long operatorId;

    /** 操作人员 */
    @Excel(name = "操作人员")
    private String operatorName;

    /** 操作日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "操作日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date operatorTime;

    /** 所在工作台 */
    @Excel(name = "所在工作台")
    private Long workstationId;

    /** 扣减方式: 1：正常扣减 2：BOM外扣减 */
    @Excel(name = "扣减方式: 1：正常扣减 2：BOM外扣减")
    private Long depletionMethod;

    /** 预留字段1 */
    @Excel(name = "预留字段1")
    private String attr1;

    /** 预留字段2 */
    @Excel(name = "预留字段2")
    private String attr2;

    /** 预留字段3 */
    @Excel(name = "预留字段3")
    private Long attr3;

    /** 预留字段4 */
    @Excel(name = "预留字段4")
    private Long attr4;

    public void setRecordId(Long recordId)
    {
        this.recordId = recordId;
    }

    public Long getRecordId()
    {
        return recordId;
    }
    public void setTaskId(Long taskId)
    {
        this.taskId = taskId;
    }

    public Long getTaskId()
    {
        return taskId;
    }
    public void setMaterialBatchNumber(String materialBatchNumber)
    {
        this.materialBatchNumber = materialBatchNumber;
    }

    public String getMaterialBatchNumber()
    {
        return materialBatchNumber;
    }
    public void setQuantity(BigDecimal quantity)
    {
        this.quantity = quantity;
    }

    public BigDecimal getQuantity()
    {
        return quantity;
    }
    public void setOperatorId(Long operatorId)
    {
        this.operatorId = operatorId;
    }

    public Long getOperatorId()
    {
        return operatorId;
    }
    public void setOperatorName(String operatorName)
    {
        this.operatorName = operatorName;
    }

    public String getOperatorName()
    {
        return operatorName;
    }
    public void setOperatorTime(Date operatorTime)
    {
        this.operatorTime = operatorTime;
    }

    public Date getOperatorTime()
    {
        return operatorTime;
    }
    public void setWorkstationId(Long workstationId)
    {
        this.workstationId = workstationId;
    }

    public Long getWorkstationId()
    {
        return workstationId;
    }
    public void setDepletionMethod(Long depletionMethod)
    {
        this.depletionMethod = depletionMethod;
    }

    public Long getDepletionMethod()
    {
        return depletionMethod;
    }
    public void setAttr1(String attr1)
    {
        this.attr1 = attr1;
    }

    public String getAttr1()
    {
        return attr1;
    }
    public void setAttr2(String attr2)
    {
        this.attr2 = attr2;
    }

    public String getAttr2()
    {
        return attr2;
    }
    public void setAttr3(Long attr3)
    {
        this.attr3 = attr3;
    }

    public Long getAttr3()
    {
        return attr3;
    }
    public void setAttr4(Long attr4)
    {
        this.attr4 = attr4;
    }

    public Long getAttr4()
    {
        return attr4;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("recordId", getRecordId())
            .append("taskId", getTaskId())
            .append("materialBatchNumber", getMaterialBatchNumber())
            .append("quantity", getQuantity())
            .append("operatorId", getOperatorId())
            .append("operatorName", getOperatorName())
            .append("operatorTime", getOperatorTime())
            .append("workstationId", getWorkstationId())
            .append("depletionMethod", getDepletionMethod())
            .append("remark", getRemark())
            .append("attr1", getAttr1())
            .append("attr2", getAttr2())
            .append("attr3", getAttr3())
            .append("attr4", getAttr4())
            .toString();
    }
}
