package com.ximai.mes.dv.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ximai.mes.dv.domain.devBrandQuotation.DvBrandQuotationProcess;
import com.ximai.mes.dv.service.devBrandQuotation.IDvBrandQuotationProcessService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 【请填写功能名称】Controller
 *
 * @author yinjinlu
 * @date 2024-01-25
 */
@RestController
@RequestMapping("/dv/process")
public class DvBrandQuotationProcessController extends BaseController
{
    @Autowired
    private IDvBrandQuotationProcessService devBrandQuotationProcessService;

    /**
     * 查询【请填写功能名称】列表
     */
    @PreAuthorize("@ss.hasPermi('md:process:list')")
    @GetMapping("/list")
    public TableDataInfo list(DvBrandQuotationProcess devBrandQuotationProcess)
    {
        startPage();
        List<DvBrandQuotationProcess> list = devBrandQuotationProcessService.selectDevBrandQuotationProcessList(devBrandQuotationProcess);
        return getDataTable(list);
    }
    /**
     * 获取【请填写功能名称】详细信息
     */
    @PreAuthorize("@ss.hasPermi('md:process:query')")
    @GetMapping(value = "/{brandQuotationProcessId}")
    public AjaxResult getInfo(@PathVariable("brandQuotationProcessId") Long brandQuotationProcessId)
    {
        return AjaxResult.success(devBrandQuotationProcessService.selectDevBrandQuotationProcessByBrandQuotationProcessId(brandQuotationProcessId));
    }

    /**
     * 新增【请填写功能名称】
     */
    @PreAuthorize("@ss.hasPermi('md:process:add')")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody DvBrandQuotationProcess devBrandQuotationProcess)
    {
        return toAjax(devBrandQuotationProcessService.insertDevBrandQuotationProcess(devBrandQuotationProcess));
    }

    /**
     * 修改【请填写功能名称】
     */
    @PreAuthorize("@ss.hasPermi('md:process:edit')")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody DvBrandQuotationProcess devBrandQuotationProcess)
    {
        return toAjax(devBrandQuotationProcessService.updateDevBrandQuotationProcess(devBrandQuotationProcess));
    }

    /**
     * 删除【请填写功能名称】
     */
    @PreAuthorize("@ss.hasPermi('md:process:remove')")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.DELETE)
	@DeleteMapping("/{brandQuotationProcessIds}")
    public AjaxResult remove(@PathVariable Long[] brandQuotationProcessIds)
    {
        return toAjax(devBrandQuotationProcessService.deleteDevBrandQuotationProcessByBrandQuotationProcessIds(brandQuotationProcessIds));
    }
}
