package com.ximai.mes.aspect;

import java.lang.annotation.*;

/**
 * 方法扩展处理
 */
@Target({ElementType.PARAMETER, ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface MethodExtendedProcess {



    /**
     * 系统参数开关名，不配置为默认开启
     * @return
     */
    String sysSwitchParam() default "";

    /**
     * 处理实现类
     *
     * @return
     */
    Class<? extends IExtendedProcess> processClz();

    /**
     * 是否新开线程
     * @return
     */
    boolean newThread() default false;

    /**
     * 是否捕获异常
     * 仅对非新开线程有效
     * @return
     */
    boolean errorCatch() default false;
}
