package com.ximai.mes.tm.service;

import com.ximai.mes.tm.domain.TmToolMachines;
import com.ximai.mes.tm.domain.TmToolMachinesRecord;

import java.util.List;

/**
 * 刀模版上下机记录Service接口
 *
 * @author generator
 * @date 2024-02-06
 */
public interface ITmToolMachinesRecordService {
    /**
     * 查询刀模版上下机记录
     *
     * @param toolMachinesRecordId 刀模版上下机记录主键
     * @return 刀模版上下机记录
     */
    TmToolMachinesRecord selectTmToolMachinesRecordByToolMachinesRecordId(Long toolMachinesRecordId);

    /**
     * 查询刀模版上下机记录
     *
     * @param toolMachinesRecordId 刀模版上下机记录主键
     * @return 刀模版上下机记录
     */
    TmToolMachinesRecord selectByToolMachinesRecordId(Long toolMachinesRecordId);

    /**
     * 查询刀模版上下机记录列表
     *
     * @param tmToolMachinesRecord 刀模版上下机记录
     * @return 刀模版上下机记录集合
     */
    List<TmToolMachinesRecord> selectTmToolMachinesRecordList(TmToolMachinesRecord tmToolMachinesRecord);

    /**
     * 新增刀模版上下机记录
     *
     * @param tmToolMachinesRecord 刀模版上下机记录
     * @return 结果
     */
    int insertTmToolMachinesRecord(TmToolMachinesRecord tmToolMachinesRecord);

    /**
     * 修改刀模版上下机记录
     *
     * @param tmToolMachinesRecord 刀模版上下机记录
     * @return 结果
     */
    int updateTmToolMachinesRecord(TmToolMachinesRecord tmToolMachinesRecord);

    /**
     * 批量删除刀模版上下机记录
     *
     * @param toolMachinesRecordIds 需要删除的刀模版上下机记录主键集合
     * @return 结果
     */
    int deleteTmToolMachinesRecordByToolMachinesRecordIds(Long[] toolMachinesRecordIds);

    /**
     * 删除刀模版上下机记录信息
     *
     * @param toolMachinesRecordId 刀模版上下机记录主键
     * @return 结果
     */
    int deleteTmToolMachinesRecordByToolMachinesRecordId(Long toolMachinesRecordId);

    /**
     * 通过申请单id获取领用单勾选工装夹具列表
     *
     * @param tmToolRequestUse 申请单主键
     * @return
     */
    List<TmToolMachines> getRecordsByProcessIdAndArrangeCode(TmToolMachines tmToolMachines);
}
