package com.ximai.mes.tm.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;
import java.util.List;

/**
 * 刀模版申请单对象 tm_tool_request
 *
 * @author generator
 * @date 2024-02-02
 */
@Data
@NoArgsConstructor
public class TmToolRequest extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    @TableId
    private Long toolRequestId;

    private Long taskWorkunitId;

    @TableField(exist = false)
    private Long toolRequestUseId;
    /**
     * 申请单编码
     */
    @Excel(name = "申请单编码")
    private String toolRequestCode;

    /**
     * 工序id
     */
    @Excel(name = "工序id")
    private Long processId;

    /**
     * 作业单元id
     */
    @Excel(name = "作业单元id")
    private Long workunitId;

    /**
     * 申请时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "申请时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date requestDate;
    private Integer estimatedLifeTime;


    /**
     * 预计开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "预计开始时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date startTime;

    /**
     * 预计结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "预计结束时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date endTime;

    /**
     * 申请数量
     */
    @Excel(name = "申请数量")
    private Integer requestNum;

    /**
     * 编排单号
     */
    @Excel(name = "编排单号")
    private String arrangeCode;

    private Long taskId;

    //表外字段
    /**
     * 工序名称
     */
    @Excel(name = "工序名称")
    private String processName;
    /**
     * 工作单元名称
     */
    @Excel(name = "工作单元名称")
    private String workunitName;

    private List<TmToolRequestItem> imToolRequestItemList;
}
