package com.ximai.mes.pro.service.impl.prototypeMake;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.pro.mapper.prototypeMake.ProPrototypeMakeBomMapper;
import com.ximai.mes.pro.domain.prototypeMake.ProPrototypeMakeBom;
import com.ximai.mes.pro.service.prototypeMake.IProPrototypeMakeBomService;

/**
 * 样品制作BOMService业务层处理
 *
 * @author zht
 * @date 2024-01-20
 */
@Service
public class ProPrototypeMakeBomServiceImpl implements IProPrototypeMakeBomService
{
    @Autowired
    private ProPrototypeMakeBomMapper proPrototypeMakeBomMapper;

    /**
     * 查询样品制作BOM
     *
     * @param bomItemId 样品制作BOM主键
     * @return 样品制作BOM
     */
    @Override
    public ProPrototypeMakeBom selectProPrototypeMakeBomByBomItemId(Long bomItemId)
    {
        return proPrototypeMakeBomMapper.selectProPrototypeMakeBomByBomItemId(bomItemId);
    }

    /**
     * 查询样品制作BOM列表
     *
     * @param proPrototypeMakeBom 样品制作BOM
     * @return 样品制作BOM
     */
    @Override
    public List<ProPrototypeMakeBom> selectProPrototypeMakeBomList(ProPrototypeMakeBom proPrototypeMakeBom)
    {
        return proPrototypeMakeBomMapper.selectProPrototypeMakeBomList(proPrototypeMakeBom);
    }

    /**
     * 新增样品制作BOM
     *
     * @param proPrototypeMakeBom 样品制作BOM
     * @return 结果
     */
    @Override
    public int insertProPrototypeMakeBom(ProPrototypeMakeBom proPrototypeMakeBom)
    {
        return proPrototypeMakeBomMapper.insertProPrototypeMakeBom(proPrototypeMakeBom);
    }

    /**
     * 修改样品制作BOM
     *
     * @param proPrototypeMakeBom 样品制作BOM
     * @return 结果
     */
    @Override
    public int updateProPrototypeMakeBom(ProPrototypeMakeBom proPrototypeMakeBom)
    {
        return proPrototypeMakeBomMapper.updateProPrototypeMakeBom(proPrototypeMakeBom);
    }

    /**
     * 批量删除样品制作BOM
     *
     * @param bomItemIds 需要删除的样品制作BOM主键
     * @return 结果
     */
    @Override
    public int deleteProPrototypeMakeBomByBomItemIds(Long[] bomItemIds)
    {
        return proPrototypeMakeBomMapper.deleteProPrototypeMakeBomByBomItemIds(bomItemIds);
    }

    /**
     * 删除样品制作BOM信息
     *
     * @param bomItemId 样品制作BOM主键
     * @return 结果
     */
    @Override
    public int deleteProPrototypeMakeBomByBomItemId(Long bomItemId)
    {
        return proPrototypeMakeBomMapper.deleteProPrototypeMakeBomByBomItemId(bomItemId);
    }
}
