package com.ximai.mes.pro.mapper.proWorkOrder;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkorder;
import com.ximai.mes.pro.domain.vo.*;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.Date;
import java.util.List;

/**
 * 生产工单Mapper接口
 *
 * @date 2022-05-09
 */
public interface ProWorkorderMapper extends BaseMapper<ProWorkorder> {
    /**
     * 查询生产工单
     *
     * @param workorderId 生产工单主键
     * @return 生产工单
     */
    ProWorkorder selectWorkorderById(Long workorderId);

    //根据workorderId获取itemId
    @Select(value = " select pw.workorder_id, pw.workorder_code, pw.workorder_name, pw.workorder_type,\n" +
            "pw.order_source, pw.source_code, pw.product_id, pw.product_code, pw.product_name, pw.product_spc,\n" +
            "pw.unit_of_measure, pw.batch_code, pw.arrange_code, pw.quantity, pw.quantity_produced, pw.client_id,\n" +
            "pw.client_code, pw.client_name, pw.vendor_id, pw.vendor_code, pw.vendor_name, pw.request_date, pw.parent_id,\n" +
            "pw.ancestors, pw.status, pw.remark, pw.attr1, pw.attr2, pw.attr3, pw.attr4, pw.create_by, pw.create_time,\n" +
            "pw.update_by, pw.update_time,b.item_id\n" +
            " from pro_workorder pw " +
            "left join pro_workorder_bom b on pw.workorder_id=b.workorder_id where pw.workorder_id=#{workorderId} ")
    List<ProWorkorderVo1> selectProWorkorderByWorkorderitem(@Param("workorderId") Long workorderId);

    /**
     * 查询生产工单列表
     *
     * @param proWorkorder 生产工单
     * @return 生产工单集合
     */
    List<ProWorkorder> selectProWorkorderList(ProWorkorderQuery proWorkorder);


    List<ProWorkorder> selectProWorkorderGorupArrangeByWorkorderIds(Long[] workorderIds);

    List<ProWorkorder> selectProWorkorderByTaskId(ProWorkorder proWorkorder);

    /**
     * 查询生产工单（关联任务单）
     *
     * @param query 生产工单
     * @return 结果
     */
    @Select(value = "select * from pro_workorder t1 left join pro_task_workorder t2 on t1.workorder_id = t2.workorder_id\n" +
            "${ew.customSqlSegment}")
    List<ProWorkorder> selectProWorkorderJoinTask(@Param("ew") QueryWrapper<ProWorkorder> query);


    @Select(value = "select t1.*,t2.item_type_name,t2.item_type_id from pro_workorder t1 left join md_item t2 on t1.product_id = t2.item_id\n" +
            "${ew.customSqlSegment}")
    List<ProWorkorder> selectListByQw(@Param("ew") QueryWrapper<ProWorkorder> query);


    @Select(value = "select distinct t3.workorder_id from pro_task_workunit t1 inner join pro_task t2 on t1.task_id = t2.task_id left join pro_task_workorder t3 on t2.task_id = t3.task_id ${ew.customSqlSegment}")
    List<Long> selectIdsByQw(@Param("ew") QueryWrapper<ProWorkorder> query);

    @Select(value = "select distinct t1.*,i.item_type_name,i.item_type_id from pro_workorder t1 left join pro_task_workorder t2 on t1.workorder_id = t2.workorder_id " +
            "left join pro_task t3 on t2.task_id = t3.task_id left join pro_task_workunit t4 on t3.task_id = t4.task_id left join md_item i on t1.product_id = i.item_id ${ew.customSqlSegment}")
    List<ProWorkorder> selectJoinTaskWorkunitByQw(@Param("ew") QueryWrapper<ProWorkorder> query);


    /**
     * 新增生产工单
     *
     * @param proWorkorder 生产工单
     * @return 结果
     */
    int insertProWorkorder(ProWorkorder proWorkorder);

    /**
     * 修改生产工单
     *
     * @param proWorkorder 生产工单
     * @return 结果
     */
    int updateProWorkorder(ProWorkorder proWorkorder);

    int updateStatusByCode(ProWorkorder proWorkorder);

    /**
     * 删除生产工单
     *
     * @param workorderId 生产工单主键
     * @return 结果
     */
    int deleteProWorkorderByWorkorderId(Long workorderId);

    /**
     * 批量删除生产工单
     *
     * @param workorderIds 需要删除的数据主键集合
     * @return 结果
     */
    int deleteProWorkorderByWorkorderIds(Long[] workorderIds);

    void updateWorkorderStatus(@Param("workorderId") Long workorderId, @Param("status") String status);

    int updateWoStatusByArrangeCode(ProWorkorder proWorkorder);

    @Select(value = "select MAX(CAST(substring_index(workorder_code,'-',-1) as signed))  from pro_workorder where parent_id = (select workorder_id from pro_workorder  where workorder_code=#{workorderCode})")
    Integer selectProWorkorderByParentCode(String workorderCode);

    @Select("select * from pro_workorder where workorder_code=#{workorderCode}")
    ProWorkorder selectProWorkorderWorderCode(@Param("workorderCode") String workorderCode);

    @Select("select * from pro_workorder where arrange_code in (select arrange_code from  pro_workorder where workorder_code =#{workorderCode})")
    List<ProWorkorder> selectArrangeOrderByCode(@Param("workorderCode") String workorderCode);

    @Select("select pw.arrange_code,pw.workorder_code,pwsd.sales_voucher,pwsd.sales_voucher_item from pro_workorder  pw left join pro_work_order_so_directive pwsd on pw.workorder_id = pwsd.workorder_id ${ew.customSqlSegment} ")
    List<ProWorkorder> selectSaleAndWorkorderList(@Param("ew") QueryWrapper<ProWorkorder> query);

    @Select("select  DISTINCT md.item_id, md.item_code, md.item_name, md.specification, md.item_type_name\n" +
            "\t, md.unit_of_measure,w.is_backflush ,w.is_backflush\n" +
            "from pro_work_order_process_item w\n" +
            "\tleft join pro_work_order_process m on w.workorder_process_id = m.workorder_process_id\n" +
            "\tleft join md_item md on w.item_id = md.item_id ${ew.customSqlSegment}")
    List<ProWorkOrderBomVo> selectProWorkOrderJoinItem(@Param("ew") QueryWrapper<ProWorkOrderProcessVo> query2);

    @Select("  select w.process_name, task.task_id,w.process_id,task.process_name,task.arrange_code,task.`status`,task.quantity  from pro_work_order_process w LEFT JOIN pro_task_workorder ta on ta.workorder_id=w.workorder_id\n" +
            "\tLEFT JOIN pro_task task on ta.task_id=task.task_id ${ew.customSqlSegment}")
    List<ProProcessTaskVo> selectProWorkorderProcessWorkorderId(@Param("ew") QueryWrapper<ProProcessTaskVo> query);

    @Select("select w.quantity,w.rush_order,so.type_no,so.color_no,so.prod_usage,w.sap_item_code as product_code,\n" +
            "concat(group_key,group_counter) as group_counter from pro_workorder w left join   \n" +
            "pro_work_order_so_directive so  on  w.workorder_id=so.workorder_id where w.workorder_id=#{workorderId}")

    ProWorkorderMateVo selectproWorkOrderSoDirective(@Param("workorderId") Long workorderId);

    @Select(value = "select max(erp_create_time) from pro_workorder")
    Date maxErpCreateTime();

    @Select(value = "select max(erp_update_time) from pro_workorder")
    Date maxErpUpdateTime();
}
