package com.ximai.mes.pro.domain.productionRequest;

import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;

import java.math.BigDecimal;

/**
 * 量产申请对象 pro_production_request
 *
 * @author chicheng.li
 * @date 2024-01-22
 */
public class ProProductionRequest extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 量产申请单ID */
    private Long productionRequestId;

    /** 量产申请单编码 */
    @Excel(name = "量产申请单编码")
    private String productionRequestCode;

    /** 工艺路线ID */
    @Excel(name = "工艺路线ID")
    private Long routeId;

    /** 产品ID */
    @Excel(name = "产品ID")
    private Long itemId;

    private String itemName;

    private String routeName;

    /** 制造工厂ID */
    @Excel(name = "制造工厂ID")
    private Long factoryId;

    private String factoryName;

    /** 仓库 */
    @Excel(name = "仓库")
    private String warehouse;

    /** 尺码组 */
    @Excel(name = "尺码组")
    private String sizeGroup;

    /** 是否要鞋图 */
    @Excel(name = "是否要鞋图")
    private Integer isNeedShoeImg;

    /** 是否附样品 */
    @Excel(name = "是否附样品")
    private Integer isNeedPrototype;

    /** 唯一码产品 */
    @Excel(name = "唯一码产品")
    private Integer isUniqueCode;

    /** 不考虑型体配色 */
    @Excel(name = "不考虑型体配色")
    private Integer isConsiderColor;

    /** 是否禁用 */
    @Excel(name = "是否禁用")
    private Integer isDisabled;

    /** 鞋图 */
    @Excel(name = "鞋图")
    private String shoeImg;

    /** 样品 */
    @Excel(name = "样品")
    private String prototype;

    /** 状态 */
    @Excel(name = "状态")
    private Integer productionRequestStatus;

    /** 长;单位cm */
    @Excel(name = "长;单位cm")
    private BigDecimal length;

    /** 宽;单位cm */
    @Excel(name = "宽;单位cm")
    private BigDecimal width;

    /** 高;单位cm */
    @Excel(name = "高;单位cm")
    private BigDecimal height;

    /** 厚度;单位mm */
    @Excel(name = "厚度;单位mm")
    private BigDecimal thick;

    /** 成品克重;单位g */
    @Excel(name = "成品克重;单位g")
    private BigDecimal weight;

    /** 角型 */
    @Excel(name = "角型")
    private String angleType;

    /**是否异型**/
    private String isAllotype;

    /**是否直角**/
    private String isRightAngle;

    /**圆角**/
    private BigDecimal fillet;

    /** 角度(单位mm) */
    @Excel(name = "角度(单位mm)")
    private BigDecimal angle;

    /** 孔径(单位mm) */
    @Excel(name = "孔径(单位mm)")
    private BigDecimal aperture;

    /** 单层厚(单位丝) */
    @Excel(name = "单层厚(单位丝)")
    private BigDecimal singleLayerThick;

    /** 单重(单位KG) */
    @Excel(name = "单重(单位KG)")
    private BigDecimal singleWeight;

    /** 层数 */
    @Excel(name = "层数")
    private BigDecimal layerNum;

    /** 是否防霉(is_open) */
    @Excel(name = "是否防霉(is_open)")
    private String isMould;

    /** 是否写码(is_open) */
    @Excel(name = "是否写码(is_open)")
    private String isCoding;

    /** 体系认证(product_sys_certification) */
    @Excel(name = "体系认证(product_sys_certification)")
    private String certification;

    /** 样品形状：RIGHT-直角；ALLOTYPE-异型；FILLET-圆角； */
    @Excel(name = "样品形状：RIGHT-直角；ALLOTYPE-异型；FILLET-圆角；")
    private String shape;

    /** 样品形状大小（mm） */
    @Excel(name = "样品形状大小", readConverterExp = "m=m")
    private BigDecimal shapeSize;

    public BigDecimal getLength() {
        return length;
    }

    public void setLength(BigDecimal length) {
        this.length = length;
    }

    public BigDecimal getWidth() {
        return width;
    }

    public void setWidth(BigDecimal width) {
        this.width = width;
    }

    public BigDecimal getHeight() {
        return height;
    }

    public void setHeight(BigDecimal height) {
        this.height = height;
    }

    public BigDecimal getThick() {
        return thick;
    }

    public void setThick(BigDecimal thick) {
        this.thick = thick;
    }

    public BigDecimal getWeight() {
        return weight;
    }

    public void setWeight(BigDecimal weight) {
        this.weight = weight;
    }

    public String getAngleType() {
        return angleType;
    }

    public void setAngleType(String angleType) {
        this.angleType = angleType;
    }

    public String getIsAllotype() {
        return isAllotype;
    }

    public void setIsAllotype(String isAllotype) {
        this.isAllotype = isAllotype;
    }

    public String getIsRightAngle() {
        return isRightAngle;
    }

    public void setIsRightAngle(String isRightAngle) {
        this.isRightAngle = isRightAngle;
    }

    public BigDecimal getFillet() {
        return fillet;
    }

    public void setFillet(BigDecimal fillet) {
        this.fillet = fillet;
    }

    public BigDecimal getAngle() {
        return angle;
    }

    public void setAngle(BigDecimal angle) {
        this.angle = angle;
    }

    public BigDecimal getAperture() {
        return aperture;
    }

    public void setAperture(BigDecimal aperture) {
        this.aperture = aperture;
    }

    public BigDecimal getSingleLayerThick() {
        return singleLayerThick;
    }

    public void setSingleLayerThick(BigDecimal singleLayerThick) {
        this.singleLayerThick = singleLayerThick;
    }

    public BigDecimal getSingleWeight() {
        return singleWeight;
    }

    public void setSingleWeight(BigDecimal singleWeight) {
        this.singleWeight = singleWeight;
    }

    public BigDecimal getLayerNum() {
        return layerNum;
    }

    public void setLayerNum(BigDecimal layerNum) {
        this.layerNum = layerNum;
    }

    public String getIsMould() {
        return isMould;
    }

    public void setIsMould(String isMould) {
        this.isMould = isMould;
    }

    public String getIsCoding() {
        return isCoding;
    }

    public void setIsCoding(String isCoding) {
        this.isCoding = isCoding;
    }

    public String getCertification() {
        return certification;
    }

    public void setCertification(String certification) {
        this.certification = certification;
    }

    public String getShape() {
        return shape;
    }

    public void setShape(String shape) {
        this.shape = shape;
    }

    public BigDecimal getShapeSize() {
        return shapeSize;
    }

    public void setShapeSize(BigDecimal shapeSize) {
        this.shapeSize = shapeSize;
    }

    public void setProductionRequestId(Long productionRequestId)
    {
        this.productionRequestId = productionRequestId;
    }

    public Long getProductionRequestId()
    {
        return productionRequestId;
    }
    public void setProductionRequestCode(String productionRequestCode)
    {
        this.productionRequestCode = productionRequestCode;
    }

    public String getProductionRequestCode()
    {
        return productionRequestCode;
    }
    public void setRouteId(Long routeId)
    {
        this.routeId = routeId;
    }

    public Long getRouteId()
    {
        return routeId;
    }
    public void setItemId(Long itemId)
    {
        this.itemId = itemId;
    }

    public Long getItemId()
    {
        return itemId;
    }
    public void setFactoryId(Long factoryId)
    {
        this.factoryId = factoryId;
    }

    public Long getFactoryId()
    {
        return factoryId;
    }
    public void setWarehouse(String warehouse)
    {
        this.warehouse = warehouse;
    }

    public String getWarehouse()
    {
        return warehouse;
    }
    public void setSizeGroup(String sizeGroup)
    {
        this.sizeGroup = sizeGroup;
    }

    public String getSizeGroup()
    {
        return sizeGroup;
    }
    public void setIsNeedShoeImg(Integer isNeedShoeImg)
    {
        this.isNeedShoeImg = isNeedShoeImg;
    }

    public Integer getIsNeedShoeImg()
    {
        return isNeedShoeImg;
    }
    public void setIsNeedPrototype(Integer isNeedPrototype)
    {
        this.isNeedPrototype = isNeedPrototype;
    }

    public Integer getIsNeedPrototype()
    {
        return isNeedPrototype;
    }
    public void setIsUniqueCode(Integer isUniqueCode)
    {
        this.isUniqueCode = isUniqueCode;
    }

    public Integer getIsUniqueCode()
    {
        return isUniqueCode;
    }
    public void setIsConsiderColor(Integer isConsiderColor)
    {
        this.isConsiderColor = isConsiderColor;
    }

    public Integer getIsConsiderColor()
    {
        return isConsiderColor;
    }
    public void setIsDisabled(Integer isDisabled)
    {
        this.isDisabled = isDisabled;
    }

    public Integer getIsDisabled()
    {
        return isDisabled;
    }
    public void setShoeImg(String shoeImg)
    {
        this.shoeImg = shoeImg;
    }

    public String getShoeImg()
    {
        return shoeImg;
    }
    public void setPrototype(String prototype)
    {
        this.prototype = prototype;
    }

    public String getPrototype()
    {
        return prototype;
    }
    public void setProductionRequestStatus(Integer productionRequestStatus)
    {
        this.productionRequestStatus = productionRequestStatus;
    }

    public String getFactoryName() {
        return factoryName;
    }

    public void setFactoryName(String factoryName) {
        this.factoryName = factoryName;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getRouteName() {
        return routeName;
    }

    public void setRouteName(String routeName) {
        this.routeName = routeName;
    }

    public Integer getProductionRequestStatus()
    {
        return productionRequestStatus;
    }

    @Override
    public String toString() {
        return "ProProductionRequest{" +
                "productionRequestId=" + productionRequestId +
                ", productionRequestCode='" + productionRequestCode + '\'' +
                ", routeId=" + routeId +
                ", itemId=" + itemId +
                ", itemName='" + itemName + '\'' +
                ", routeName='" + routeName + '\'' +
                ", factoryId=" + factoryId +
                ", factoryName='" + factoryName + '\'' +
                ", warehouse='" + warehouse + '\'' +
                ", sizeGroup='" + sizeGroup + '\'' +
                ", isNeedShoeImg=" + isNeedShoeImg +
                ", isNeedPrototype=" + isNeedPrototype +
                ", isUniqueCode=" + isUniqueCode +
                ", isConsiderColor=" + isConsiderColor +
                ", isDisabled=" + isDisabled +
                ", shoeImg='" + shoeImg + '\'' +
                ", prototype='" + prototype + '\'' +
                ", productionRequestStatus=" + productionRequestStatus +
                ", length=" + length +
                ", width=" + width +
                ", height=" + height +
                ", thick=" + thick +
                ", weight=" + weight +
                ", angleType='" + angleType + '\'' +
                ", isAllotype='" + isAllotype + '\'' +
                ", isRightAngle='" + isRightAngle + '\'' +
                ", fillet=" + fillet +
                ", angle=" + angle +
                ", aperture=" + aperture +
                ", singleLayerThick=" + singleLayerThick +
                ", singleWeight=" + singleWeight +
                ", layerNum=" + layerNum +
                ", isMould='" + isMould + '\'' +
                ", isCoding='" + isCoding + '\'' +
                ", certification='" + certification + '\'' +
                ", shape='" + shape + '\'' +
                ", shapeSize=" + shapeSize +
                '}';
    }
}
