package com.ximai.mes.md.mapper;

import java.util.List;
import com.ximai.mes.md.domain.MdSalesPaymentClause;

/**
 * 销售订单付款条件Mapper接口
 *
 * @author yinjinlu
 * @date 2024-01-22
 */
public interface MdSalesPaymentClauseMapper
{
    /**
     * 查询销售订单付款条件
     *
     * @param id 销售订单付款条件主键
     * @return 销售订单付款条件
     */
    public MdSalesPaymentClause selectMdSalesPaymentClauseById(String id);

    /**
     * 查询销售订单付款条件列表
     *
     * @param mdSalesPaymentClause 销售订单付款条件
     * @return 销售订单付款条件集合
     */
    public List<MdSalesPaymentClause> selectMdSalesPaymentClauseList(MdSalesPaymentClause mdSalesPaymentClause);

    /**
     * 新增销售订单付款条件
     *
     * @param mdSalesPaymentClause 销售订单付款条件
     * @return 结果
     */
    public int insertMdSalesPaymentClause(MdSalesPaymentClause mdSalesPaymentClause);

    /**
     * 修改销售订单付款条件
     *
     * @param mdSalesPaymentClause 销售订单付款条件
     * @return 结果
     */
    public int updateMdSalesPaymentClause(MdSalesPaymentClause mdSalesPaymentClause);

    /**
     * 删除销售订单付款条件
     *
     * @param id 销售订单付款条件主键
     * @return 结果
     */
    public int deleteMdSalesPaymentClauseById(String id);

    /**
     * 批量删除销售订单付款条件
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteMdSalesPaymentClauseByIds(String[] ids);
}
